/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.location;

import android.content.Context;
import android.content.Intent;
import android.graphics.drawable.AnimationDrawable;
import android.location.Location;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.annotation.StringRes;
import android.support.v4.content.ContextCompat;
import android.support.v7.app.AppCompatActivity;
import android.text.TextUtils;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import com.amap.api.maps2d.AMap;
import com.amap.api.maps2d.AMapUtils;
import com.amap.api.maps2d.CameraUpdateFactory;
import com.amap.api.maps2d.UiSettings;
import com.amap.api.maps2d.model.BitmapDescriptor;
import com.amap.api.maps2d.model.BitmapDescriptorFactory;
import com.amap.api.maps2d.model.CameraPosition;
import com.amap.api.maps2d.model.CircleOptions;
import com.amap.api.maps2d.model.LatLng;
import com.amap.api.maps2d.model.Marker;
import com.amap.api.maps2d.model.MarkerOptions;
import com.amap.api.maps2d.model.MyLocationStyle;
import com.amap.api.services.core.LatLonPoint;
import com.amap.api.services.core.PoiItem;
import com.amap.api.services.poisearch.PoiResult;
import com.amap.api.services.poisearch.PoiSearch;
import com.blankj.utilcode.utils.ConvertUtils;
import com.blankj.utilcode.utils.ToastUtils;
import com.xdja.eoa.commonutil.ArraysUtils;
import com.xdja.eoa.commonwidget.widget.CommonToolBar;
import com.xdja.eoa.commonwidget.widget.OnToolBarButtonClickListener;
import com.xdja.eoa.commonwidget.widget.ToolBarButtonType;
import com.xdja.eoa.commonwidget.widget.ToolbarButton;
import com.xdja.location.EoaMapView;
import com.xdja.location.LocationActivity;
import com.xdja.location.PoiSearchAdapter;
import com.xdja.location.R;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class ChooseLocationActivity
extends AppCompatActivity
implements AMap.OnMyLocationChangeListener,
PoiSearch.OnPoiSearchListener,
AMap.OnCameraChangeListener,
OnToolBarButtonClickListener,
View.OnClickListener {
    public static final String EXTRA_RADIUS = "extra_radius";
    public static final String EXTRA_LATITUDE = "extra_latitude";
    public static final String EXTRA_LONGITUDE = "extra_longitude";
    public static final String EXTRA_POI_NAME = "extra_poi_name";
    public static final String EXTRA_ADDRESS = "extra_address";
    public static final String EXTRA_ERROR_CODE = "extra_error_code";
    private CommonToolBar mToolBar;
    private EoaMapView mMapView;
    private ListView mListView;
    private ImageView mZoomIn;
    private ImageView mZoomOut;
    private View mLoadingView;
    private ImageView mProgress;
    private View mErrorView;
    private TextView mErrorTip;
    private AMap mAMap;
    private float mZoomLevel = 17.0f;
    private int mRadius;
    private int mMaxDistance = 8000;
    private double mLatitude;
    private double mLongitude;
    private Marker locationMarker;
    private PoiSearchAdapter mAdapter;

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.location_activity_choose_location);
        this.getData();
        this.initView();
        this.initMap(savedInstanceState);
        this.initAdapter();
    }

    private void getData() {
        Bundle bundle = this.getIntent().getExtras();
        if (bundle != null) {
            this.mRadius = bundle.getInt(EXTRA_RADIUS);
            this.mMaxDistance = this.mRadius > 0 ? this.mRadius : this.mMaxDistance;
            this.mLatitude = bundle.getDouble(EXTRA_LATITUDE);
            this.mLongitude = bundle.getDouble(EXTRA_LONGITUDE);
        }
    }

    private void initView() {
        this.mToolBar = (CommonToolBar)this.findViewById(R.id.location_toolbar);
        this.mToolBar.setBarButtonClickListener((OnToolBarButtonClickListener)this);
        this.mMapView = (EoaMapView)this.findViewById(R.id.location_mapview);
        this.mListView = (ListView)this.findViewById(R.id.location_listview);
        ImageView locate = (ImageView)this.findViewById(R.id.location_locate);
        this.mZoomIn = (ImageView)this.findViewById(R.id.location_zoom_in);
        this.mZoomOut = (ImageView)this.findViewById(R.id.location_zoom_out);
        locate.setOnClickListener((View.OnClickListener)this);
        this.mZoomIn.setOnClickListener((View.OnClickListener)this);
        this.mZoomOut.setOnClickListener((View.OnClickListener)this);
        this.mLoadingView = this.findViewById(R.id.location_loading);
        this.mProgress = (ImageView)this.findViewById(R.id.location_loading_progress);
        this.mErrorView = this.findViewById(R.id.location_error);
        this.mErrorTip = (TextView)this.findViewById(R.id.location_error_tip);
        this.disableToolbarBtn();
        this.showLoadingView();
    }

    private void initMap(Bundle savedInstanceState) {
        this.mMapView.onCreate(savedInstanceState);
        if (this.mAMap == null) {
            this.mAMap = this.mMapView.getMap();
        }
        UiSettings uiSettings = this.mAMap.getUiSettings();
        uiSettings.setZoomControlsEnabled(false);
        MyLocationStyle myLocationStyle = new MyLocationStyle();
        myLocationStyle.myLocationType(1);
        BitmapDescriptor locationIcon = BitmapDescriptorFactory.fromResource((int)R.drawable.location_ic_detail_marker);
        myLocationStyle.myLocationIcon(locationIcon);
        myLocationStyle.radiusFillColor(ContextCompat.getColor((Context)this, (int)17170445));
        myLocationStyle.strokeColor(ContextCompat.getColor((Context)this, (int)17170445));
        this.mAMap.setMyLocationStyle(myLocationStyle);
        this.mAMap.setMyLocationEnabled(true);
        this.mAMap.animateCamera(CameraUpdateFactory.zoomTo((float)this.mZoomLevel));
        this.mAMap.setOnMyLocationChangeListener((AMap.OnMyLocationChangeListener)this);
        this.mAMap.setOnCameraChangeListener((AMap.OnCameraChangeListener)this);
    }

    private void initAdapter() {
        this.mAdapter = new PoiSearchAdapter((Context)this);
        this.mListView.setAdapter((ListAdapter)this.mAdapter);
        this.mListView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                LocationActivity.selectedItem = (PoiItem)ChooseLocationActivity.this.mAdapter.getItem(position);
                ChooseLocationActivity.this.mAdapter.notifyDataSetChanged();
                ChooseLocationActivity.this.addOrUpdateMarker();
            }
        });
    }

    protected void onDestroy() {
        super.onDestroy();
        this.mMapView.onDestroy();
    }

    protected void onResume() {
        super.onResume();
        this.mMapView.onResume();
    }

    protected void onPause() {
        super.onPause();
        this.mMapView.onPause();
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        this.mMapView.onSaveInstanceState(outState);
    }

    public void onMyLocationChange(Location location) {
        int errorCode = location.getExtras().getInt("errorCode");
        if (errorCode == 0) {
            if (this.mRadius > 0) {
                this.mAMap.addCircle(new CircleOptions().center(new LatLng(location.getLatitude(), location.getLongitude())).radius((double)this.mRadius).fillColor(ContextCompat.getColor((Context)this, (int)R.color.location_circle_fill_color)).strokeColor(ContextCompat.getColor((Context)this, (int)R.color.location_circle_stroke_color)).strokeWidth((float)ConvertUtils.dp2px((float)1.0f)));
            }
            String cityCode = location.getExtras().getString("citycode");
            this.doPoiSearch(cityCode, location.getLatitude(), location.getLongitude());
        } else {
            this.hideLoadingView();
            this.showErrorView(R.string.location_failure);
        }
    }

    private void doPoiSearch(String cityCode, double latitude, double longitude) {
        String ctgr = "\u653f\u5e9c\u673a\u6784\u53ca\u793e\u4f1a\u56e2\u4f53|\u516c\u53f8\u4f01\u4e1a|\u5546\u52a1\u4f4f\u5b85|\u79d1\u6559\u6587\u5316\u670d\u52a1|\u91d1\u878d\u4fdd\u9669\u670d\u52a1|\u516c\u5171\u8bbe\u65bd|\u751f\u6d3b\u670d\u52a1";
        PoiSearch.Query query = new PoiSearch.Query("", ctgr, cityCode);
        query.setPageSize(1000);
        query.setPageNum(0);
        PoiSearch poiSearch = new PoiSearch((Context)this, query);
        poiSearch.setBound(new PoiSearch.SearchBound(new LatLonPoint(latitude, longitude), this.mMaxDistance));
        poiSearch.setOnPoiSearchListener((PoiSearch.OnPoiSearchListener)this);
        poiSearch.searchPOIAsyn();
    }

    public void onPoiSearched(PoiResult poiResult, int rCode) {
        this.hideLoadingView();
        if (rCode == 1000) {
            if (poiResult == null) {
                return;
            }
            ArrayList poiItems = poiResult.getPois();
            if (ArraysUtils.isListEmpty((Collection)poiItems)) {
                return;
            }
            if (this.mLatitude > 0.0 && this.mLongitude > 0.0) {
                this.findPoi(new LatLng(this.mLatitude, this.mLongitude), poiItems);
            }
            this.mAdapter.setData(poiItems);
            this.mAdapter.notifyDataSetChanged();
            this.enableToolbarBtn();
        } else {
            this.showErrorView(R.string.location_poi_error);
        }
    }

    public void onPoiItemSearched(PoiItem poiItem, int i) {
    }

    private void findPoi(final LatLng selectedLatLng, List<PoiItem> poiItems) {
        PoiItem poiItem = Collections.min(poiItems, new Comparator<PoiItem>(){

            @Override
            public int compare(PoiItem o1, PoiItem o2) {
                LatLng latLng1 = new LatLng(o1.getLatLonPoint().getLatitude(), o1.getLatLonPoint().getLongitude());
                LatLng latLng2 = new LatLng(o2.getLatLonPoint().getLatitude(), o2.getLatLonPoint().getLongitude());
                float distance1 = AMapUtils.calculateLineDistance((LatLng)selectedLatLng, (LatLng)latLng1);
                float distance2 = AMapUtils.calculateLineDistance((LatLng)selectedLatLng, (LatLng)latLng2);
                return Float.compare(distance1, distance2);
            }
        });
        LatLng latLng = new LatLng(poiItem.getLatLonPoint().getLatitude(), poiItem.getLatLonPoint().getLongitude());
        float distance = AMapUtils.calculateLineDistance((LatLng)selectedLatLng, (LatLng)latLng);
        if (distance <= (float)this.mMaxDistance) {
            LocationActivity.selectedItem = poiItem;
            this.addOrUpdateMarker();
        }
    }

    private void addOrUpdateMarker() {
        LatLonPoint point = LocationActivity.selectedItem.getLatLonPoint();
        LatLng latLng = new LatLng(point.getLatitude(), point.getLongitude());
        if (this.locationMarker == null) {
            this.locationMarker = this.mAMap.addMarker(new MarkerOptions().position(latLng).draggable(true).icon(BitmapDescriptorFactory.fromResource((int)R.drawable.location_icon_local)));
            return;
        }
        this.locationMarker.setPosition(latLng);
    }

    private void enableToolbarBtn() {
        ToolbarButton toolbarButton = this.mToolBar.getButtonIdByType(ToolBarButtonType.RIGHT_FIRST_BUTTON);
        toolbarButton.setEnabled(true);
        toolbarButton.setColor(ContextCompat.getColor((Context)this, (int)R.color.location_title_right));
    }

    private void disableToolbarBtn() {
        ToolbarButton toolbarButton = this.mToolBar.getButtonIdByType(ToolBarButtonType.RIGHT_FIRST_BUTTON);
        toolbarButton.setEnabled(false);
        toolbarButton.setColor(ContextCompat.getColor((Context)this, (int)R.color.location_title_right_disabled));
    }

    private void showLoadingView() {
        this.mLoadingView.setVisibility(0);
        AnimationDrawable animationDrawable = (AnimationDrawable)this.mProgress.getDrawable();
        animationDrawable.start();
    }

    private void hideLoadingView() {
        this.mLoadingView.setVisibility(8);
        AnimationDrawable animationDrawable = (AnimationDrawable)this.mProgress.getDrawable();
        animationDrawable.stop();
    }

    private void showErrorView(@StringRes int errorTip) {
        this.mListView.setVisibility(8);
        this.mErrorView.setVisibility(0);
        this.mErrorTip.setText(errorTip);
    }

    public void onCameraChange(CameraPosition cameraPosition) {
    }

    public void onCameraChangeFinish(CameraPosition cameraPosition) {
        this.mZoomLevel = cameraPosition.zoom;
        if (this.mZoomLevel >= this.mAMap.getMaxZoomLevel()) {
            this.mZoomIn.setImageResource(R.drawable.location_ic_zoom_in_disable);
        } else if (this.mZoomLevel <= this.mAMap.getMinZoomLevel()) {
            this.mZoomOut.setImageResource(R.drawable.location_ic_zoom_out_disable);
        } else {
            this.mZoomIn.setImageResource(R.drawable.location_ic_zoom_in);
            this.mZoomOut.setImageResource(R.drawable.location_ic_zoom_out);
        }
    }

    public void onClick(View v, ToolBarButtonType type) {
        if (type == ToolBarButtonType.LEFT_FIRST_BUTTON) {
            this.finish();
        } else if (type == ToolBarButtonType.RIGHT_FIRST_BUTTON) {
            if (LocationActivity.selectedItem == null) {
                ToastUtils.showShortToast((CharSequence)"\u8bf7\u9009\u62e9\u4f4d\u7f6e");
                return;
            }
            PoiItem poiItem = LocationActivity.selectedItem;
            LocationActivity.selectedItem = null;
            Intent intent = new Intent();
            intent.putExtra(EXTRA_LATITUDE, poiItem.getLatLonPoint().getLatitude());
            intent.putExtra(EXTRA_LONGITUDE, poiItem.getLatLonPoint().getLongitude());
            String title = poiItem.getTitle();
            String snippet = poiItem.getSnippet();
            intent.putExtra(EXTRA_POI_NAME, title);
            intent.putExtra(EXTRA_ADDRESS, TextUtils.isEmpty((CharSequence)snippet) ? title : snippet);
            this.setResult(-1, intent);
            this.finish();
        }
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.location_zoom_in) {
            this.mAMap.animateCamera(CameraUpdateFactory.zoomTo((float)(this.mZoomLevel += 1.0f)));
        } else if (id2 == R.id.location_zoom_out) {
            this.mAMap.animateCamera(CameraUpdateFactory.zoomTo((float)(this.mZoomLevel -= 1.0f)));
        } else if (id2 == R.id.location_locate) {
            // empty if block
        }
    }
}

