/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.location;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import com.amap.api.location.AMapLocation;
import com.amap.api.location.AMapLocationClient;
import com.amap.api.location.AMapLocationClientOption;
import com.amap.api.location.AMapLocationListener;
import com.rabbit.blade.comm.util.LogUtil;

public class GaodeMapUtil {
    private AMapLocationClient mLocationClient;
    private AMapLocationClientOption mLocationOption;
    public static final String LOCATION_RESULT_CODE = "location_result_code";

    public GaodeMapUtil(Context context, final Handler handler) {
        this.mLocationClient = new AMapLocationClient(context);
        this.mLocationClient.setLocationListener(new AMapLocationListener(){

            public void onLocationChanged(AMapLocation amapLocation) {
                if (amapLocation != null) {
                    Message message = new Message();
                    Bundle locationData = new Bundle();
                    locationData.putInt(GaodeMapUtil.LOCATION_RESULT_CODE, amapLocation.getErrorCode());
                    if (amapLocation.getErrorCode() == 0) {
                        locationData.putString("address", amapLocation.getPoiName());
                        locationData.putString("addressdetail", amapLocation.getAddress());
                        locationData.putDouble("latitude", amapLocation.getLatitude());
                        locationData.putDouble("longitude", amapLocation.getLongitude());
                    } else {
                        LogUtil.getUtils().e((Object)("AmapError location Error, ErrCode:" + amapLocation.getErrorCode() + ", errInfo:" + amapLocation.getErrorInfo()));
                    }
                    message.setData(locationData);
                    handler.sendMessage(message);
                    LogUtil.getUtils().i((Object)amapLocation.getAddress());
                    GaodeMapUtil.this.mLocationClient.stopLocation();
                    GaodeMapUtil.this.mLocationClient.onDestroy();
                }
            }
        });
        this.mLocationOption = new AMapLocationClientOption();
        this.mLocationOption.setLocationMode(AMapLocationClientOption.AMapLocationMode.Hight_Accuracy);
        this.mLocationOption.setNeedAddress(true);
        this.mLocationOption.setOnceLocation(true);
        this.mLocationOption.setWifiActiveScan(true);
        this.mLocationOption.setMockEnable(false);
        this.mLocationOption.setInterval(2000L);
        this.mLocationClient.setLocationOption(this.mLocationOption);
        this.mLocationClient.startLocation();
    }
}

