/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.location;

import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Rect;
import android.graphics.drawable.AnimationDrawable;
import android.location.Location;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Bundle;
import android.os.Environment;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.support.v7.app.AppCompatActivity;
import android.text.TextUtils;
import android.util.Log;
import android.view.DragEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.AdapterView;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;
import com.amap.api.location.AMapLocation;
import com.amap.api.location.AMapLocationClient;
import com.amap.api.location.AMapLocationClientOption;
import com.amap.api.location.AMapLocationListener;
import com.amap.api.maps2d.AMap;
import com.amap.api.maps2d.CameraUpdateFactory;
import com.amap.api.maps2d.LocationSource;
import com.amap.api.maps2d.MapView;
import com.amap.api.maps2d.UiSettings;
import com.amap.api.maps2d.model.BitmapDescriptor;
import com.amap.api.maps2d.model.BitmapDescriptorFactory;
import com.amap.api.maps2d.model.CameraPosition;
import com.amap.api.maps2d.model.LatLng;
import com.amap.api.maps2d.model.MarkerOptions;
import com.amap.api.maps2d.model.MyLocationStyle;
import com.amap.api.services.core.LatLonPoint;
import com.amap.api.services.core.PoiItem;
import com.amap.api.services.geocoder.GeocodeResult;
import com.amap.api.services.geocoder.GeocodeSearch;
import com.amap.api.services.geocoder.RegeocodeQuery;
import com.amap.api.services.geocoder.RegeocodeResult;
import com.amap.api.services.poisearch.PoiResult;
import com.amap.api.services.poisearch.PoiSearch;
import com.blankj.utilcode.utils.LogUtils;
import com.xdja.location.BitmapUtils;
import com.xdja.location.ImageBean;
import com.xdja.location.PoiSearchAdapter;
import com.xdja.location.R;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class LocationActivity
extends AppCompatActivity
implements AMap.OnMapScreenShotListener,
LocationSource,
GeocodeSearch.OnGeocodeSearchListener,
PoiSearch.OnPoiSearchListener,
AMapLocationListener,
AMap.OnCameraChangeListener {
    private AMap aMap;
    private Context mContext;
    private PoiSearchAdapter adapter;
    private List<PoiItem> items = new ArrayList<PoiItem>();
    private PoiResult poiResult;
    public static PoiItem selectedItem;
    private AMapLocation currentLocation;
    public AMapLocationClient mLocationClient = null;
    public AMapLocationClientOption mLocationOption = null;
    private LocationSource.OnLocationChangedListener mListener = null;
    private int currentPage = 0;
    private PoiSearch.Query query;
    private PoiSearch poiSearch;
    private GeocodeSearch geocoderSearch;
    private boolean isFromTopicRelease;
    private MapView mapView;
    private ListView listView;
    private ImageView myLocationBtn;
    private RelativeLayout progressLayout;
    private RelativeLayout bottomLayout;
    private RelativeLayout mapLayout;
    private RelativeLayout errorLayout;
    private ImageView dialog_progress;
    public static final String MAP = "map";
    public static final String ADDRESS = "address";
    public static final String LONGITUDE = "longitude";
    public static final String LATITUDE = "latitude";
    public static final String CITYCODE = "citycode";
    public static final String ADDRESS_DETAIL = "addressdetail";
    public static final String FROM_TOPIC_RELEASE = "from_topic_release";
    public static final String IS_CAN_CHANGE_LOCATION = "is_can_change_location";

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.location_activity_location);
        this.mContext = this;
        this.initview(savedInstanceState);
        this.initLogice();
    }

    private void initview(Bundle savedInstanceState) {
        this.mapView = (MapView)this.findViewById(R.id.map);
        this.mapView.onCreate(savedInstanceState);
        this.listView = (ListView)this.findViewById(R.id.listView);
        this.adapter = new PoiSearchAdapter((Context)this);
        this.listView.setAdapter((ListAdapter)this.adapter);
        this.listView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                if (LocationActivity.this.isCanChangeLocation()) {
                    LocationActivity.this.listItemClick(position);
                }
            }
        });
        this.myLocationBtn = (ImageView)this.findViewById(R.id.myLocationBtn);
        this.myLocationBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                LocationActivity.this.startLocation();
            }
        });
        this.mapView.setOnDragListener(new View.OnDragListener(){

            public boolean onDrag(View v, DragEvent event) {
                ((InputMethodManager)LocationActivity.this.getSystemService("input_method")).hideSoftInputFromWindow(v.getWindowToken(), 2);
                return false;
            }
        });
        this.progressLayout = (RelativeLayout)this.findViewById(R.id.progress);
        this.bottomLayout = (RelativeLayout)this.findViewById(R.id.bottomLayout);
        this.mapLayout = (RelativeLayout)this.findViewById(R.id.mapLayout);
        this.errorLayout = (RelativeLayout)this.findViewById(R.id.error_layout);
        this.dialog_progress = (ImageView)this.findViewById(R.id.dialog_progress);
        this.errorLayout.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                LocationActivity.this.errorLayoutClick();
            }
        });
        if (!this.isNetworkAvailable()) {
            Toast.makeText((Context)this.mContext, (CharSequence)this.getString(R.string.location_network_error_hint), (int)0).show();
            this.showErrorLayout();
        } else {
            this.errorLayout.setVisibility(8);
            this.bottomLayout.setVisibility(0);
        }
    }

    private void initLogice() {
        this.getData(this.getIntent());
        this.initMap();
        this.initLocate();
    }

    public boolean isCanChangeLocation() {
        if (this.getIntent() == null) {
            return true;
        }
        return this.getIntent().getBooleanExtra(IS_CAN_CHANGE_LOCATION, true);
    }

    private void initLocate() {
        if (this.isNetworkAvailable()) {
            if (this.isFromTopicRelease && selectedItem != null) {
                this.aMap.moveCamera(CameraUpdateFactory.zoomTo((float)17.0f));
                this.aMap.moveCamera(CameraUpdateFactory.changeLatLng((LatLng)new LatLng(selectedItem.getLatLonPoint().getLatitude(), selectedItem.getLatLonPoint().getLongitude())));
                this.aMap.addMarker(new MarkerOptions().position(new LatLng(selectedItem.getLatLonPoint().getLatitude(), selectedItem.getLatLonPoint().getLongitude())).icon(BitmapDescriptorFactory.fromBitmap((Bitmap)BitmapFactory.decodeResource((Resources)this.getResources(), (int)R.drawable.location_icon_local))).draggable(false));
            } else {
                this.showProgressLayout(true);
            }
            this.mLocationClient.startLocation();
        }
    }

    public void listItemClick(int position) {
        selectedItem = (PoiItem)this.adapter.getItem(position);
        this.getMapScreenShot(null);
    }

    public void getMapScreenShot(View v) {
        this.aMap.getMapScreenShot((AMap.OnMapScreenShotListener)this);
        this.aMap.invalidate();
    }

    protected void onResume() {
        super.onResume();
        this.mapView.onResume();
    }

    protected void onPause() {
        super.onPause();
        this.mapView.onPause();
        this.mLocationClient.stopLocation();
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        this.mapView.onSaveInstanceState(outState);
    }

    protected void onDestroy() {
        super.onDestroy();
        this.mapView.onDestroy();
        this.mLocationClient.onDestroy();
    }

    public void onMapScreenShot(Bitmap bitmap) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        if (null == bitmap) {
            return;
        }
        String filepath = Environment.getExternalStorageDirectory() + "/map_" + sdf.format(new Date()) + ".amap";
        try {
            FileOutputStream fos = new FileOutputStream(filepath);
            bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)fos);
            try {
                fos.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                fos.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        ImageBean imageBean = new ImageBean();
        imageBean.setMiniMap(BitmapUtils.getMiniMap2(bitmap));
        imageBean.setPath(filepath);
        Intent intent = new Intent();
        intent.putExtra(MAP, (Serializable)imageBean);
        intent.putExtra(ADDRESS, selectedItem.getTitle());
        intent.putExtra(ADDRESS_DETAIL, selectedItem.getSnippet());
        intent.putExtra(LONGITUDE, String.valueOf(selectedItem.getLatLonPoint().getLongitude()));
        intent.putExtra(LATITUDE, String.valueOf(selectedItem.getLatLonPoint().getLatitude()));
        this.setResult(-1, intent);
        this.finish();
        selectedItem = null;
    }

    public void startLocation() {
        this.mLocationClient.startLocation();
    }

    public void errorLayoutClick() {
        Intent intent = new Intent();
        intent.setClass((Context)this, LocationActivity.class);
        intent.setFlags(0x20000000);
        if (selectedItem != null) {
            intent.putExtra(ADDRESS, selectedItem.getTitle());
            intent.putExtra(ADDRESS_DETAIL, selectedItem.getSnippet());
            intent.putExtra(LONGITUDE, String.valueOf(selectedItem.getLatLonPoint().getLongitude()));
            intent.putExtra(LATITUDE, String.valueOf(selectedItem.getLatLonPoint().getLatitude()));
        }
        intent.putExtra(FROM_TOPIC_RELEASE, this.isFromTopicRelease);
        this.startActivity(intent);
    }

    public boolean isNetworkAvailable() {
        ConnectivityManager mgr = (ConnectivityManager)this.getSystemService("connectivity");
        NetworkInfo[] info = mgr.getAllNetworkInfo();
        if (info != null) {
            for (int i = 0; i < info.length; ++i) {
                if (info[i].getState() != NetworkInfo.State.CONNECTED) continue;
                return true;
            }
        }
        return false;
    }

    public void showErrorLayout() {
        this.errorLayout.setVisibility(0);
        this.bottomLayout.setVisibility(8);
    }

    public void showProgressLayout(boolean show) {
        if (show) {
            this.progressLayout.setVisibility(0);
            this.dialog_progress.setImageResource(R.drawable.location_inner_animation);
            AnimationDrawable animationDrawable = (AnimationDrawable)this.dialog_progress.getDrawable();
            animationDrawable.start();
            this.listView.setVisibility(8);
        } else {
            this.progressLayout.setVisibility(8);
            this.listView.setVisibility(0);
            this.dialog_progress.setImageResource(R.drawable.location_inner_animation);
            AnimationDrawable animationDrawable = (AnimationDrawable)this.dialog_progress.getDrawable();
            animationDrawable.stop();
        }
    }

    private void getData(Intent intent) {
        if (null != intent) {
            this.isFromTopicRelease = intent.getBooleanExtra(FROM_TOPIC_RELEASE, false);
            if (this.isFromTopicRelease) {
                String address = intent.getStringExtra(ADDRESS);
                String addressDetail = intent.getStringExtra(ADDRESS_DETAIL);
                double longitude = intent.getDoubleExtra(LONGITUDE, Double.POSITIVE_INFINITY);
                double latidue = intent.getDoubleExtra(LATITUDE, Double.POSITIVE_INFINITY);
                String citycode = intent.getStringExtra(CITYCODE);
                if (Double.compare(longitude, 0.0) != 0 && Double.compare(latidue, 0.0) != 0 && !TextUtils.isEmpty((CharSequence)address)) {
                    selectedItem = new PoiItem(null, new LatLonPoint(latidue, longitude), address, addressDetail);
                    selectedItem.setCityCode(citycode);
                }
            }
        }
    }

    private void initMap() {
        if (this.aMap == null) {
            this.aMap = this.mapView.getMap();
        }
        TextView mTextView = new TextView((Context)this);
        LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(1, 1);
        mTextView.setLayoutParams((ViewGroup.LayoutParams)lp);
        int widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)1, (int)0x40000000);
        int heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)1, (int)0x40000000);
        mTextView.measure(widthMeasureSpec, heightMeasureSpec);
        mTextView.layout(0, 0, mTextView.getMeasuredWidth(), mTextView.getMeasuredHeight());
        mTextView.buildDrawingCache();
        Bitmap bitmap = mTextView.getDrawingCache();
        MyLocationStyle myLocationStyle = new MyLocationStyle();
        myLocationStyle.myLocationType(1);
        BitmapDescriptor locationIcon = BitmapDescriptorFactory.fromBitmap((Bitmap)bitmap);
        myLocationStyle.myLocationIcon(locationIcon);
        myLocationStyle.radiusFillColor(ContextCompat.getColor((Context)this, (int)17170445));
        myLocationStyle.strokeColor(ContextCompat.getColor((Context)this, (int)17170445));
        this.aMap.setMyLocationStyle(myLocationStyle);
        this.aMap.setLocationSource((LocationSource)this);
        this.aMap.setOnCameraChangeListener((AMap.OnCameraChangeListener)this);
        this.mLocationClient = new AMapLocationClient(this.getApplicationContext());
        this.mLocationClient.setLocationListener((AMapLocationListener)this);
        this.mLocationOption = new AMapLocationClientOption();
        this.mLocationOption.setLocationMode(AMapLocationClientOption.AMapLocationMode.Hight_Accuracy);
        this.mLocationOption.setNeedAddress(true);
        this.mLocationOption.setOnceLocation(true);
        this.mLocationOption.setWifiActiveScan(true);
        this.mLocationOption.setMockEnable(false);
        this.mLocationClient.setLocationOption(this.mLocationOption);
        UiSettings settings = this.aMap.getUiSettings();
        settings.setMyLocationButtonEnabled(false);
        settings.setZoomControlsEnabled(true);
        settings.setLogoPosition(0);
        this.aMap.setMyLocationEnabled(true);
        this.geocoderSearch = new GeocodeSearch((Context)this);
        this.geocoderSearch.setOnGeocodeSearchListener((GeocodeSearch.OnGeocodeSearchListener)this);
    }

    public void activate(LocationSource.OnLocationChangedListener onLocationChangedListener) {
        this.mListener = onLocationChangedListener;
    }

    public void deactivate() {
        this.mListener = null;
    }

    public void onRegeocodeSearched(RegeocodeResult regeocodeResult, int rCode) {
        LogUtils.d((Object)"onRegeocodeSearched");
        if (rCode == 1000) {
            this.doSearchQuery("", regeocodeResult.getRegeocodeQuery().getPoint().getLatitude(), regeocodeResult.getRegeocodeQuery().getPoint().getLongitude(), regeocodeResult.getRegeocodeAddress().getCityCode());
        } else {
            this.showErrorLayout();
        }
    }

    public void onGeocodeSearched(GeocodeResult geocodeResult, int i) {
        LogUtils.d((Object)"onGeocodeSearched");
    }

    protected void doSearchQuery(String key, double latitude, double longitude, String cityCode) {
        this.showProgressLayout(true);
        this.currentPage = 0;
        this.query = new PoiSearch.Query(key, "\u653f\u5e9c\u673a\u6784\u53ca\u793e\u4f1a\u56e2\u4f53|\u516c\u53f8\u4f01\u4e1a|\u5546\u52a1\u4f4f\u5b85|\u79d1\u6559\u6587\u5316\u670d\u52a1|\u91d1\u878d\u4fdd\u9669\u670d\u52a1|\u516c\u5171\u8bbe\u65bd|\u751f\u6d3b\u670d\u52a1", cityCode);
        this.query.setPageSize(20);
        this.query.setPageNum(this.currentPage);
        this.poiSearch = new PoiSearch((Context)this, this.query);
        this.poiSearch.setOnPoiSearchListener((PoiSearch.OnPoiSearchListener)this);
        if (TextUtils.isEmpty((CharSequence)key)) {
            this.poiSearch.setBound(new PoiSearch.SearchBound(new LatLonPoint(latitude, longitude), 8000));
        }
        this.poiSearch.searchPOIAsyn();
    }

    public void onPoiSearched(PoiResult result, int rCode) {
        this.showProgressLayout(false);
        if (rCode == 1000) {
            if (result != null && result.getQuery() != null) {
                if (result.getQuery().equals((Object)this.query)) {
                    this.poiResult = result;
                    ArrayList poiItems = this.poiResult.getPois();
                    if (poiItems != null && poiItems.size() > 0) {
                        ((InputMethodManager)this.getSystemService("input_method")).hideSoftInputFromWindow(this.getWindow().getDecorView().getWindowToken(), 2);
                        this.items = poiItems;
                        if (null != selectedItem) {
                            for (int i = 0; i < this.items.size(); ++i) {
                                if (!this.items.get(i).getTitle().equals(selectedItem.getTitle())) continue;
                                this.items.remove(i);
                                this.items.add(0, selectedItem);
                                break;
                            }
                        }
                        this.adapter.setData(this.items);
                        this.adapter.notifyDataSetChanged();
                        selectedItem = this.items.get(0);
                    }
                } else {
                    Log.d((String)"renjw", (String)"POI \u641c\u7d22\u65e0\u7ed3\u679c1");
                }
            }
        } else {
            Log.d((String)"renjw", (String)"POI \u641c\u7d22\u65e0\u7ed3\u679c2");
        }
    }

    public void onPoiItemSearched(PoiItem poiItem, int i) {
    }

    public void onLocationChanged(AMapLocation aMapLocation) {
        if (null != aMapLocation) {
            this.aMap.clear();
            this.currentLocation = aMapLocation;
            this.aMap.moveCamera(CameraUpdateFactory.zoomTo((float)17.0f));
            this.aMap.moveCamera(CameraUpdateFactory.changeLatLng((LatLng)new LatLng(this.currentLocation.getLatitude(), this.currentLocation.getLongitude())));
            this.mListener.onLocationChanged((Location)this.currentLocation);
            this.aMap.addMarker(new MarkerOptions().position(new LatLng(this.currentLocation.getLatitude(), this.currentLocation.getLongitude())).icon(BitmapDescriptorFactory.fromBitmap((Bitmap)BitmapFactory.decodeResource((Resources)this.getResources(), (int)R.drawable.location_icon_local))).draggable(false));
            if (this.currentLocation != null) {
                RegeocodeQuery query = new RegeocodeQuery(new LatLonPoint(this.currentLocation.getLatitude(), this.currentLocation.getLongitude()), 200.0f, "autonavi");
                this.geocoderSearch.getFromLocationAsyn(query);
            }
        }
    }

    public void onCameraChange(CameraPosition cameraPosition) {
    }

    public void onCameraChangeFinish(CameraPosition cameraPosition) {
    }

    public boolean dispatchTouchEvent(MotionEvent event) {
        View v;
        if ((event.getAction() == 0 || event.getAction() == 2) && (v = this.getCurrentFocus()) instanceof EditText) {
            Rect outRect = new Rect();
            v.getGlobalVisibleRect(outRect);
            if (!outRect.contains((int)event.getRawX(), (int)event.getRawY())) {
                v.clearFocus();
                ((InputMethodManager)this.getSystemService("input_method")).hideSoftInputFromWindow(v.getWindowToken(), 2);
            }
        }
        return super.dispatchTouchEvent(event);
    }

    public void onPointerCaptureChanged(boolean hasCapture) {
    }
}

