/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.location;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.support.v7.app.AppCompatActivity;
import android.util.Log;
import android.view.View;
import android.widget.TextView;
import com.amap.api.location.AMapLocationClient;
import com.amap.api.location.AMapLocationClientOption;
import com.amap.api.maps2d.AMap;
import com.amap.api.maps2d.CameraUpdateFactory;
import com.amap.api.maps2d.UiSettings;
import com.amap.api.maps2d.model.BitmapDescriptorFactory;
import com.amap.api.maps2d.model.LatLng;
import com.amap.api.maps2d.model.MarkerOptions;
import com.amap.api.services.core.LatLonPoint;
import com.amap.api.services.geocoder.GeocodeAddress;
import com.amap.api.services.geocoder.GeocodeQuery;
import com.amap.api.services.geocoder.GeocodeResult;
import com.amap.api.services.geocoder.GeocodeSearch;
import com.amap.api.services.geocoder.RegeocodeQuery;
import com.amap.api.services.geocoder.RegeocodeResult;
import com.xdja.eoa.commonutil.ArraysUtils;
import com.xdja.eoa.commonutil.StatusBarUtil;
import com.xdja.eoa.commonwidget.widget.CommonToolBar;
import com.xdja.location.EoaMapView;
import com.xdja.location.R;
import com.xdja.location.params.LocationDetailParams;
import java.util.Collection;

public class LocationDetailActivity
extends AppCompatActivity
implements GeocodeSearch.OnGeocodeSearchListener {
    public static final String PARAM_LOCATION_DETAIL = "params_location_detail";
    private LocationDetailParams detailParams;
    private CommonToolBar toolbarLocationDetail;
    private EoaMapView mapView;
    private TextView tvLocationTitle;
    private TextView tvLocationDesc;
    private AMap aMap;
    public AMapLocationClient mLocationClient = null;
    public AMapLocationClientOption mLocationOption = null;
    private GeocodeSearch geocodeSearch;

    public static void start(Context context, LocationDetailParams params) {
        Intent starter = new Intent(context, LocationDetailActivity.class);
        starter.putExtra(PARAM_LOCATION_DETAIL, (Parcelable)params);
        context.startActivity(starter);
    }

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.location_activity_location_detail);
        if (this.getIntent() == null || !this.getIntent().hasExtra(PARAM_LOCATION_DETAIL)) {
            this.finish();
            return;
        }
        this.initView(savedInstanceState);
        this.initMap();
        this.searchLocationData();
    }

    private void initView(Bundle savedInstanceState) {
        this.toolbarLocationDetail = (CommonToolBar)this.findViewById(R.id.toolbar_location_detail);
        this.mapView = (EoaMapView)this.findViewById(R.id.view_map);
        this.mapView.onCreate(savedInstanceState);
        this.tvLocationTitle = (TextView)this.findViewById(R.id.tv_location_title);
        this.tvLocationDesc = (TextView)this.findViewById(R.id.tv_location_desc);
        StatusBarUtil.immersive((Activity)this);
        StatusBarUtil.setPaddingSmart((Context)this, (View)this.toolbarLocationDetail);
        StatusBarUtil.darkMode((Activity)this);
    }

    private void initMap() {
        if (this.aMap == null) {
            this.aMap = this.mapView.getMap();
        }
        this.mLocationClient = new AMapLocationClient(this.getApplicationContext());
        this.mLocationOption = new AMapLocationClientOption();
        this.mLocationOption.setLocationMode(AMapLocationClientOption.AMapLocationMode.Hight_Accuracy);
        this.mLocationOption.setNeedAddress(true);
        this.mLocationOption.setOnceLocation(true);
        this.mLocationOption.setWifiActiveScan(true);
        this.mLocationOption.setMockEnable(false);
        this.mLocationClient.setLocationOption(this.mLocationOption);
        UiSettings settings = this.aMap.getUiSettings();
        settings.setMyLocationButtonEnabled(false);
        settings.setZoomControlsEnabled(false);
        this.aMap.setMyLocationEnabled(true);
    }

    private void searchLocationData() {
        this.detailParams = (LocationDetailParams)this.getIntent().getParcelableExtra(PARAM_LOCATION_DETAIL);
        this.geocodeSearch = new GeocodeSearch((Context)this);
        this.geocodeSearch.setOnGeocodeSearchListener((GeocodeSearch.OnGeocodeSearchListener)this);
        if (this.detailParams.latitude <= 0.0 || this.detailParams.longitude <= 0.0) {
            Log.w((String)"location", (String)("latitude : " + this.detailParams.latitude + "  longitude : " + this.detailParams.longitude));
            this.searchByName(this.detailParams.desc);
        } else {
            LatLonPoint latLonPoint = new LatLonPoint(this.detailParams.latitude, this.detailParams.longitude);
            this.searchByLatLon(latLonPoint);
            this.initMapLocation(this.detailParams.latitude, this.detailParams.longitude);
        }
        this.tvLocationTitle.setText((CharSequence)this.detailParams.getDesc());
        this.tvLocationDesc.setText((CharSequence)this.detailParams.getDesc());
    }

    private void searchByLatLon(LatLonPoint latLonPoint) {
        RegeocodeQuery query = new RegeocodeQuery(latLonPoint, 200.0f, "autonavi");
        this.geocodeSearch.getFromLocationAsyn(query);
    }

    private void searchByName(String name) {
        GeocodeQuery geocodeQuery = new GeocodeQuery(name.trim(), "");
        this.geocodeSearch.getFromLocationNameAsyn(geocodeQuery);
    }

    private void initMapLocation(double lat, double lng) {
        this.aMap.moveCamera(CameraUpdateFactory.zoomTo((float)18.0f));
        this.aMap.moveCamera(CameraUpdateFactory.changeLatLng((LatLng)new LatLng(lat, lng)));
        this.aMap.addMarker(new MarkerOptions().position(new LatLng(lat, lng)).icon(BitmapDescriptorFactory.fromBitmap((Bitmap)BitmapFactory.decodeResource((Resources)this.getResources(), (int)R.drawable.location_ic_detail_marker))).draggable(false));
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        this.mapView.onSaveInstanceState(outState);
    }

    protected void onResume() {
        super.onResume();
        this.mapView.onResume();
    }

    protected void onPause() {
        super.onPause();
        this.mapView.onPause();
    }

    protected void onDestroy() {
        super.onDestroy();
        this.mapView.onDestroy();
    }

    public void onRegeocodeSearched(RegeocodeResult regeocodeResult, int rCode) {
        if (rCode != 1000) {
            this.tvLocationDesc.setText((CharSequence)this.detailParams.getDesc());
            return;
        }
        this.tvLocationDesc.setText((CharSequence)regeocodeResult.getRegeocodeAddress().getFormatAddress());
    }

    public void onGeocodeSearched(GeocodeResult geocodeResult, int rCode) {
        if (rCode != 1000) {
            this.tvLocationDesc.setText((CharSequence)this.detailParams.getDesc());
            return;
        }
        if (geocodeResult == null || ArraysUtils.isListEmpty((Collection)geocodeResult.getGeocodeAddressList())) {
            this.tvLocationDesc.setText((CharSequence)this.detailParams.getDesc());
            return;
        }
        GeocodeAddress geocodeAddress = (GeocodeAddress)geocodeResult.getGeocodeAddressList().get(0);
        this.tvLocationDesc.setText((CharSequence)geocodeAddress.getFormatAddress());
        this.initMapLocation(geocodeAddress.getLatLonPoint().getLatitude(), geocodeAddress.getLatLonPoint().getLongitude());
    }
}

