/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.location;

import android.content.Context;
import android.location.Location;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.support.v7.app.AppCompatActivity;
import com.amap.api.maps2d.AMap;
import com.amap.api.maps2d.AMapUtils;
import com.amap.api.maps2d.CameraUpdateFactory;
import com.amap.api.maps2d.UiSettings;
import com.amap.api.maps2d.model.BitmapDescriptor;
import com.amap.api.maps2d.model.BitmapDescriptorFactory;
import com.amap.api.maps2d.model.CircleOptions;
import com.amap.api.maps2d.model.LatLng;
import com.amap.api.maps2d.model.MyLocationStyle;
import com.blankj.utilcode.utils.ConvertUtils;
import com.xdja.eoa.commonutil.ArraysUtils;
import com.xdja.eoa.commonwidget.widget.CommonToolBar;
import com.xdja.location.EoaMapView;
import com.xdja.location.R;
import com.xdja.location.params.RuleAddress;
import java.util.List;

public class LocationDetailActivityV2
extends AppCompatActivity
implements AMap.OnMyLocationChangeListener {
    public static final String EXTRA_TITLE = "extra_title";
    public static final String EXTRA_ONCE_LOCATION = "extra_once_location";
    public static final String EXTRA_INTERVAL = "extra_interval";
    public static final String EXTRA_LIST_RULE_ADDRESS = "extra_list_rule_address";
    public static final String EXTRA_CURRENT_LATLNG = "extra_current_location";
    private EoaMapView mMapView;
    private AMap mAMap;
    private String mTitle;
    private boolean mOnceLocation;
    private long mInterval;
    private List<RuleAddress> mRuleAddressList;
    private LatLng mCurrentLat;

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.location_activity_location_detail_v2);
        this.getData();
        this.initView();
        this.initMap(savedInstanceState);
        this.initRuleAddress();
    }

    private void initRuleAddress() {
        if (ArraysUtils.isListEmpty(this.mRuleAddressList)) {
            return;
        }
        for (RuleAddress item : this.mRuleAddressList) {
            this.mAMap.addCircle(new CircleOptions().center(new LatLng(item.getLatitude(), item.getLongitude())).radius((double)item.getDistanceRange()).fillColor(ContextCompat.getColor((Context)this, (int)R.color.location_circle_fill_color_red)).strokeColor(ContextCompat.getColor((Context)this, (int)R.color.location_circle_stroke_color_red)).strokeWidth((float)ConvertUtils.dp2px((float)1.0f)));
        }
    }

    private void initMap(Bundle savedInstanceState) {
        this.mMapView.onCreate(savedInstanceState);
        if (this.mAMap == null) {
            this.mAMap = this.mMapView.getMap();
        }
        UiSettings uiSettings = this.mAMap.getUiSettings();
        uiSettings.setZoomControlsEnabled(false);
        MyLocationStyle myLocationStyle = new MyLocationStyle();
        if (this.mOnceLocation) {
            myLocationStyle.myLocationType(1);
        } else {
            myLocationStyle.myLocationType(2);
            myLocationStyle.interval(this.mInterval);
        }
        BitmapDescriptor locationIcon = BitmapDescriptorFactory.fromResource((int)R.drawable.location_ic_detail_marker);
        myLocationStyle.myLocationIcon(locationIcon);
        myLocationStyle.radiusFillColor(ContextCompat.getColor((Context)this, (int)17170445));
        myLocationStyle.strokeColor(ContextCompat.getColor((Context)this, (int)17170445));
        this.mAMap.setMyLocationStyle(myLocationStyle);
        this.mAMap.setMyLocationEnabled(true);
        float zoomLevel = this.getZoomLevel(this.mRuleAddressList, this.mCurrentLat);
        this.mAMap.animateCamera(CameraUpdateFactory.zoomTo((float)zoomLevel));
        this.mAMap.setOnMyLocationChangeListener((AMap.OnMyLocationChangeListener)this);
    }

    private void initView() {
        CommonToolBar toolBar = (CommonToolBar)this.findViewById(R.id.toolbar_location_detail);
        toolBar.setTitle(this.mTitle);
        this.mMapView = (EoaMapView)this.findViewById(R.id.view_map);
    }

    private void getData() {
        Bundle bundle = this.getIntent().getExtras();
        if (bundle != null) {
            this.mTitle = bundle.getString(EXTRA_TITLE, this.getString(R.string.location_title));
            this.mOnceLocation = bundle.getBoolean(EXTRA_ONCE_LOCATION);
            this.mInterval = bundle.getLong(EXTRA_INTERVAL, 2000L);
            this.mRuleAddressList = bundle.getParcelableArrayList(EXTRA_LIST_RULE_ADDRESS);
            this.mCurrentLat = (LatLng)bundle.getParcelable(EXTRA_CURRENT_LATLNG);
        }
    }

    protected void onDestroy() {
        super.onDestroy();
        this.mMapView.onDestroy();
    }

    protected void onResume() {
        super.onResume();
        this.mMapView.onResume();
    }

    protected void onPause() {
        super.onPause();
        this.mMapView.onPause();
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        this.mMapView.onSaveInstanceState(outState);
    }

    public void onMyLocationChange(Location location) {
    }

    private float getZoomLevel(List<RuleAddress> ruleAddressList, LatLng currentLat) {
        if (ArraysUtils.isListEmpty(ruleAddressList) || this.mCurrentLat == null) {
            return 17.0f;
        }
        float minDistance = 0.0f;
        for (RuleAddress address : ruleAddressList) {
            LatLng latLng = new LatLng(address.getLatitude(), address.getLongitude());
            float distance = AMapUtils.calculateLineDistance((LatLng)latLng, (LatLng)currentLat);
            if (!(minDistance > distance) && minDistance != 0.0f) continue;
            minDistance = distance;
        }
        double result = 19.0 - Math.log(minDistance / 10.0f) / Math.log(2.0);
        if (result < 3.0) {
            return 3.0f;
        }
        if (result > 19.0) {
            return 19.0f;
        }
        return (float)result;
    }
}

