/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.location;

import android.content.Context;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.CheckBox;
import android.widget.TextView;
import com.amap.api.services.core.PoiItem;
import com.xdja.location.LocationActivity;
import com.xdja.location.R;
import java.util.ArrayList;
import java.util.List;

public class PoiSearchAdapter
extends BaseAdapter {
    private List<PoiItem> items = new ArrayList<PoiItem>();
    private Context mContext;
    private LayoutInflater inflater;

    public PoiSearchAdapter(Context context) {
        this.mContext = context;
        this.inflater = (LayoutInflater)this.mContext.getSystemService("layout_inflater");
    }

    public void setData(List<PoiItem> items) {
        this.items = items;
    }

    public List<PoiItem> getData() {
        return this.items;
    }

    public int getCount() {
        return this.items.size();
    }

    public Object getItem(int position) {
        return this.items.get(position);
    }

    public long getItemId(int position) {
        return position;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        PoiItem item = this.items.get(position);
        ViewHolder holder = null;
        if (null == convertView) {
            convertView = this.inflater.inflate(R.layout.location_item_layout, null);
            holder = new ViewHolder();
            holder.addressTv = (TextView)convertView.findViewById(R.id.address);
            holder.titleTv = (TextView)convertView.findViewById(R.id.location_title);
            holder.radioButton = (CheckBox)convertView.findViewById(R.id.radioBtn);
            convertView.setTag((Object)holder);
        } else {
            holder = (ViewHolder)convertView.getTag();
        }
        String title = "";
        String snippet = "";
        if (null != item) {
            if (!TextUtils.isEmpty((CharSequence)item.getTitle())) {
                title = item.getTitle();
            }
            snippet = !TextUtils.isEmpty((CharSequence)item.getSnippet()) ? item.getSnippet() : title;
        }
        holder.titleTv.setText((CharSequence)title);
        holder.addressTv.setText((CharSequence)snippet);
        if (item == LocationActivity.selectedItem) {
            holder.radioButton.setChecked(true);
            holder.radioButton.setVisibility(0);
        } else {
            holder.radioButton.setChecked(false);
            holder.radioButton.setVisibility(8);
        }
        return convertView;
    }

    static class ViewHolder {
        TextView titleTv;
        TextView addressTv;
        CheckBox radioButton;

        ViewHolder() {
        }
    }
}

