/*
 * Decompiled with CFR 0.152.
 */
package skin.support.flycotablayout.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.DrawableRes;
import android.util.AttributeSet;
import android.view.View;
import android.widget.TextView;
import com.flyco.tablayout.R;
import com.flyco.tablayout.widget.MsgView;
import skin.support.content.res.SkinCompatResources;
import skin.support.widget.SkinCompatBackgroundHelper;
import skin.support.widget.SkinCompatHelper;
import skin.support.widget.SkinCompatSupportable;
import skin.support.widget.SkinCompatTextHelper;

public class SkinMsgView
extends MsgView
implements SkinCompatSupportable {
    private SkinCompatTextHelper mTextHelper;
    private SkinCompatBackgroundHelper mBackgroundTintHelper;
    private int mBackgroundColorResId = 0;
    private int mStrokeColorResId = 0;

    public SkinMsgView(Context context) {
        this(context, null, 0);
    }

    public SkinMsgView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SkinMsgView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.MsgView);
        this.mBackgroundColorResId = ta.getResourceId(R.styleable.MsgView_mv_backgroundColor, 0);
        this.mStrokeColorResId = ta.getResourceId(R.styleable.MsgView_mv_strokeColor, 0);
        this.applyBackgroundColorResource();
        this.applyStrokeColorResource();
        ta.recycle();
        this.mBackgroundTintHelper = new SkinCompatBackgroundHelper((View)this);
        this.mBackgroundTintHelper.loadFromAttributes(attrs, defStyleAttr);
        this.mTextHelper = SkinCompatTextHelper.create((TextView)this);
        this.mTextHelper.loadFromAttributes(attrs, defStyleAttr);
    }

    public void setBackgroundResource(@DrawableRes int resId) {
        super.setBackgroundResource(resId);
        if (this.mBackgroundTintHelper != null) {
            this.mBackgroundTintHelper.onSetBackgroundResource(resId);
        }
    }

    public void setTextAppearance(int resId) {
        this.setTextAppearance(this.getContext(), resId);
    }

    public void setTextAppearance(Context context, int resId) {
        super.setTextAppearance(context, resId);
        if (this.mTextHelper != null) {
            this.mTextHelper.onSetTextAppearance(context, resId);
        }
    }

    public void setBackgroundColorResource(int resId) {
        this.mBackgroundColorResId = resId;
        this.applyBackgroundColorResource();
    }

    private void applyBackgroundColorResource() {
        this.mBackgroundColorResId = SkinCompatHelper.checkResourceId((int)this.mBackgroundColorResId);
        if (this.mBackgroundColorResId != 0) {
            this.setBackgroundColor(SkinCompatResources.getColor((Context)this.getContext(), (int)this.mBackgroundColorResId));
        }
    }

    public void setStrokeColorResource(int resId) {
        this.mStrokeColorResId = resId;
        this.applyStrokeColorResource();
    }

    private void applyStrokeColorResource() {
        this.mStrokeColorResId = SkinCompatHelper.checkResourceId((int)this.mStrokeColorResId);
        if (this.mStrokeColorResId != 0) {
            this.setStrokeColor(SkinCompatResources.getColor((Context)this.getContext(), (int)this.mStrokeColorResId));
        }
    }

    public void applySkin() {
        this.applyBackgroundColorResource();
        this.applyStrokeColorResource();
        if (this.mBackgroundTintHelper != null) {
            this.mBackgroundTintHelper.applySkin();
        }
        if (this.mTextHelper != null) {
            this.mTextHelper.applySkin();
        }
    }
}

