/*
 * Decompiled with CFR 0.152.
 */
package skin.support.flycotablayout.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.DrawableRes;
import android.util.AttributeSet;
import android.view.View;
import com.flyco.tablayout.SegmentTabLayout;
import java.lang.reflect.Field;
import skin.support.content.res.SkinCompatResources;
import skin.support.flycotablayout.R;
import skin.support.widget.SkinCompatBackgroundHelper;
import skin.support.widget.SkinCompatHelper;
import skin.support.widget.SkinCompatSupportable;

public class SkinSegmentTabLayout
extends SegmentTabLayout
implements SkinCompatSupportable {
    private SkinCompatBackgroundHelper mBackgroundTintHelper;
    private int mIndicatorColorResId = 0;
    private int mDividerColorResId = 0;
    private int mTextSelectColorResId = 0;
    private int mTextUnselectColorResId = 0;
    private int mBarColorResId = 0;
    private int mBarStrokeColorResId = 0;

    public SkinSegmentTabLayout(Context context) {
        this(context, null, 0);
    }

    public SkinSegmentTabLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SkinSegmentTabLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.obtainAttributes(context, attrs);
        this.mBackgroundTintHelper = new SkinCompatBackgroundHelper((View)this);
        this.mBackgroundTintHelper.loadFromAttributes(attrs, defStyleAttr);
    }

    private void obtainAttributes(Context context, AttributeSet attrs) {
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.SegmentTabLayout);
        this.mIndicatorColorResId = ta.getResourceId(R.styleable.SegmentTabLayout_tl_indicator_color, 0);
        this.mIndicatorColorResId = SkinCompatHelper.checkResourceId((int)this.mIndicatorColorResId);
        this.mDividerColorResId = ta.getResourceId(R.styleable.SegmentTabLayout_tl_divider_color, this.mIndicatorColorResId);
        this.mDividerColorResId = SkinCompatHelper.checkResourceId((int)this.mDividerColorResId);
        this.mTextSelectColorResId = ta.getResourceId(R.styleable.SegmentTabLayout_tl_textSelectColor, 0);
        this.mTextSelectColorResId = SkinCompatHelper.checkResourceId((int)this.mTextSelectColorResId);
        this.mTextUnselectColorResId = ta.getResourceId(R.styleable.SegmentTabLayout_tl_textUnselectColor, this.mIndicatorColorResId);
        this.mTextUnselectColorResId = SkinCompatHelper.checkResourceId((int)this.mTextUnselectColorResId);
        this.mBarColorResId = ta.getResourceId(R.styleable.SegmentTabLayout_tl_bar_color, 0);
        this.mBarColorResId = SkinCompatHelper.checkResourceId((int)this.mBarColorResId);
        this.mBarStrokeColorResId = ta.getResourceId(R.styleable.SegmentTabLayout_tl_bar_stroke_color, this.mIndicatorColorResId);
        this.mBarStrokeColorResId = SkinCompatHelper.checkResourceId((int)this.mBarStrokeColorResId);
        ta.recycle();
        this.applySegmentTabLayoutResources();
    }

    private void applySegmentTabLayoutResources() {
        if (this.mIndicatorColorResId != 0) {
            this.setIndicatorColor(SkinCompatResources.getColor((Context)this.getContext(), (int)this.mIndicatorColorResId));
        }
        if (this.mDividerColorResId != 0) {
            this.setDividerColor(SkinCompatResources.getColor((Context)this.getContext(), (int)this.mDividerColorResId));
        }
        if (this.mTextSelectColorResId != 0) {
            this.setTextSelectColor(SkinCompatResources.getColor((Context)this.getContext(), (int)this.mTextSelectColorResId));
        }
        if (this.mTextUnselectColorResId != 0) {
            this.setTextUnselectColor(SkinCompatResources.getColor((Context)this.getContext(), (int)this.mTextUnselectColorResId));
        }
        if (this.mBarColorResId != 0) {
            this.setBarColor(SkinCompatResources.getColor((Context)this.getContext(), (int)this.mBarColorResId));
        }
        if (this.mBarStrokeColorResId != 0) {
            this.setBarStrokeColor(SkinCompatResources.getColor((Context)this.getContext(), (int)this.mBarStrokeColorResId));
        }
    }

    private void setBarColor(int color) {
        try {
            Field barColor = SegmentTabLayout.class.getDeclaredField("mBarColor");
            barColor.setAccessible(true);
            barColor.set((Object)this, color);
            this.invalidate();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setBarStrokeColor(int color) {
        try {
            Field barStrokeColor = SegmentTabLayout.class.getDeclaredField("mBarStrokeColor");
            barStrokeColor.setAccessible(true);
            barStrokeColor.set((Object)this, color);
            this.invalidate();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setBackgroundResource(@DrawableRes int resId) {
        super.setBackgroundResource(resId);
        if (this.mBackgroundTintHelper != null) {
            this.mBackgroundTintHelper.onSetBackgroundResource(resId);
        }
    }

    public void applySkin() {
        this.applySegmentTabLayoutResources();
        if (this.mBackgroundTintHelper != null) {
            this.mBackgroundTintHelper.applySkin();
        }
    }
}

