/*
 * Decompiled with CFR 0.152.
 */
package skin.support.flycotablayout.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.DrawableRes;
import android.util.AttributeSet;
import android.view.View;
import com.flyco.tablayout.SlidingTabLayout;
import skin.support.content.res.SkinCompatResources;
import skin.support.flycotablayout.R;
import skin.support.widget.SkinCompatBackgroundHelper;
import skin.support.widget.SkinCompatHelper;
import skin.support.widget.SkinCompatSupportable;

public class SkinSlidingTabLayout
extends SlidingTabLayout
implements SkinCompatSupportable {
    private SkinCompatBackgroundHelper mBackgroundTintHelper;
    private int mIndicatorColorResId = 0;
    private int mUnderlineColorResId = 0;
    private int mDividerColorResId = 0;
    private int mTextSelectColorResId = 0;
    private int mTextUnselectColorResId = 0;

    public SkinSlidingTabLayout(Context context) {
        this(context, null, 0);
    }

    public SkinSlidingTabLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SkinSlidingTabLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.obtainAttributes(context, attrs);
        this.mBackgroundTintHelper = new SkinCompatBackgroundHelper((View)this);
        this.mBackgroundTintHelper.loadFromAttributes(attrs, defStyleAttr);
    }

    private void obtainAttributes(Context context, AttributeSet attrs) {
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.SlidingTabLayout);
        this.mIndicatorColorResId = ta.getResourceId(R.styleable.SlidingTabLayout_tl_indicator_color, 0);
        this.mIndicatorColorResId = SkinCompatHelper.checkResourceId((int)this.mIndicatorColorResId);
        this.mUnderlineColorResId = ta.getResourceId(R.styleable.SlidingTabLayout_tl_underline_color, 0);
        this.mUnderlineColorResId = SkinCompatHelper.checkResourceId((int)this.mUnderlineColorResId);
        this.mDividerColorResId = ta.getResourceId(R.styleable.SlidingTabLayout_tl_divider_color, 0);
        this.mDividerColorResId = SkinCompatHelper.checkResourceId((int)this.mDividerColorResId);
        this.mTextSelectColorResId = ta.getResourceId(R.styleable.SlidingTabLayout_tl_textSelectColor, 0);
        this.mTextSelectColorResId = SkinCompatHelper.checkResourceId((int)this.mTextSelectColorResId);
        this.mTextUnselectColorResId = ta.getResourceId(R.styleable.SlidingTabLayout_tl_textUnselectColor, 0);
        this.mTextUnselectColorResId = SkinCompatHelper.checkResourceId((int)this.mTextUnselectColorResId);
        ta.recycle();
        this.applySlidingTabLayoutResources();
    }

    public void setBackgroundResource(@DrawableRes int resId) {
        super.setBackgroundResource(resId);
        if (this.mBackgroundTintHelper != null) {
            this.mBackgroundTintHelper.onSetBackgroundResource(resId);
        }
    }

    private void applySlidingTabLayoutResources() {
        if (this.mIndicatorColorResId != 0) {
            this.setIndicatorColor(SkinCompatResources.getColor((Context)this.getContext(), (int)this.mIndicatorColorResId));
        }
        if (this.mUnderlineColorResId != 0) {
            this.setUnderlineColor(SkinCompatResources.getColor((Context)this.getContext(), (int)this.mUnderlineColorResId));
        }
        if (this.mDividerColorResId != 0) {
            this.setDividerColor(SkinCompatResources.getColor((Context)this.getContext(), (int)this.mDividerColorResId));
        }
        if (this.mTextSelectColorResId != 0) {
            this.setTextSelectColor(SkinCompatResources.getColor((Context)this.getContext(), (int)this.mTextSelectColorResId));
        }
        if (this.mTextUnselectColorResId != 0) {
            this.setTextUnselectColor(SkinCompatResources.getColor((Context)this.getContext(), (int)this.mTextUnselectColorResId));
        }
    }

    public void applySkin() {
        this.applySlidingTabLayoutResources();
        if (this.mBackgroundTintHelper != null) {
            this.mBackgroundTintHelper.applySkin();
        }
    }
}

