/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.eoa.sdk.remote;

import android.content.ContentResolver;
import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Process;
import android.os.RemoteException;
import com.xdja.eoa.sdk.remote.IRemoteSdk;
import com.xdja.eoa.sdk.remote.RemoteMethodParam;
import com.xdja.eoa.sdk.remote.RemoteSdkUtils;
import com.xdja.eoa.sdk.remote.SdkLog;
import com.xdja.eoa.sdk.remote.cb.ICallbackListener;

public class OaRemoteSDK {
    private Uri mUri;
    private IRemoteSdk oaSDKBinder;
    private static OaRemoteSDK INSTANCE = null;

    private OaRemoteSDK(Uri uri) {
        this.mUri = uri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OaRemoteSDK getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<OaRemoteSDK> clazz = OaRemoteSDK.class;
        synchronized (OaRemoteSDK.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new Builder().create();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public void call(Context context, RemoteMethodParam remoteMethodParam, ICallbackListener listener) {
        block9: {
            try {
                IRemoteSdk sdkBinder = this.getBinder(context);
                if (sdkBinder == null) {
                    if (listener != null) {
                        listener.callback(-2, "", RemoteSdkUtils.getErrorMsgByCode(-2), remoteMethodParam.getMark());
                    }
                    return;
                }
                Bundle bundle = RemoteSdkUtils.getBundleForCallBinder(remoteMethodParam, listener);
                Bundle result = sdkBinder.call(bundle);
                int ret = result.getInt("ret");
                if (ret != 0) {
                    if (listener != null) {
                        listener.callback(ret, "", RemoteSdkUtils.getErrorMsgByCode(ret), remoteMethodParam.getMark());
                    }
                } else {
                    SdkLog.d("\u901a\u77e5\u63a5\u53e3\u670d\u52a1\u63d0\u4f9b\u8005\u8c03\u7528\u65b9\u6cd5--->\u6210\u529f");
                }
            }
            catch (RemoteException e) {
                SdkLog.w(e);
                if (listener != null) {
                    listener.callback(-3, "", RemoteSdkUtils.getErrorMsgByCode(-3), remoteMethodParam.getMark());
                }
            }
            catch (Exception e) {
                SdkLog.w(e);
                if (listener == null) break block9;
                listener.callback(-3, "", RemoteSdkUtils.getErrorMsgByCode(-3), remoteMethodParam.getMark());
            }
        }
    }

    private synchronized IRemoteSdk getBinder(Context context) {
        Bundle bundle;
        if (this.oaSDKBinder != null) {
            return this.oaSDKBinder;
        }
        if (context == null) {
            throw new NullPointerException("context is null");
        }
        ContentResolver resolver = context.getContentResolver();
        Bundle extra = new Bundle();
        extra.putInt("uid", Process.myUid());
        extra.putInt("pid", Process.myPid());
        try {
            bundle = resolver.call(this.mUri, "get_binder", "get_binder_OA_SDK", extra);
        }
        catch (IllegalArgumentException e) {
            SdkLog.w(e);
            return null;
        }
        catch (SecurityException e) {
            SdkLog.w(e);
            return null;
        }
        catch (Exception e) {
            SdkLog.w(e);
            return null;
        }
        if (bundle == null) {
            return null;
        }
        IBinder binder = bundle.getBinder("get_binder_OA_SDK");
        if (binder == null) {
            return null;
        }
        this.oaSDKBinder = IRemoteSdk.Stub.asInterface(binder);
        try {
            binder.linkToDeath(new IBinder.DeathRecipient(){

                public void binderDied() {
                    OaRemoteSDK.this.oaSDKBinder = null;
                }
            }, 0);
        }
        catch (RemoteException e) {
            SdkLog.w(e);
        }
        return this.oaSDKBinder;
    }

    public static final class Builder {
        private Uri uri;
        private static final Uri URI_DEFAULT = Uri.parse((String)"content://com.xdja.eoa.sdk.SdkBinderProvider");

        public Builder baseUri(Uri uri) {
            if (uri == null) {
                throw new NullPointerException("uri is null!");
            }
            this.uri = uri;
            return this;
        }

        public OaRemoteSDK create() {
            if (this.uri == null) {
                this.uri = URI_DEFAULT;
            }
            return new OaRemoteSDK(this.uri);
        }
    }
}

