/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.eoa.sdk.remote;

import android.os.Bundle;
import android.os.IBinder;
import com.alibaba.fastjson.JSON;
import com.xdja.eoa.sdk.remote.RemoteMethodParam;
import com.xdja.eoa.sdk.remote.cb.ICallbackListener;
import com.xdja.eoa.sdk.remote.cb.RealCallBack;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class RemoteSdkUtils {
    public static Bundle getBundleForCallBinder(RemoteMethodParam remoteMethodParam, ICallbackListener listener) {
        Bundle bundle = new Bundle();
        String methodData = JSON.toJSONString((Object)remoteMethodParam);
        bundle.putString("binder_call_method_data", methodData);
        if (listener != null) {
            RealCallBack cb = RealCallBack.create(listener, remoteMethodParam.getMark());
            bundle.putBinder("binder_call_method_callback", (IBinder)cb);
        }
        return bundle;
    }

    public static String getErrorMsgByCode(int errorCode) {
        String errorMsg = "";
        switch (errorCode) {
            case -4: {
                errorMsg = "\u53c2\u6570\u975e\u6cd5";
                break;
            }
            case -6: {
                errorMsg = "\u8c03\u7528\u65b9\u6cd5\u4e0d\u652f\u6301";
                break;
            }
            case -3: {
                errorMsg = "\u901a\u77e5\u63a5\u53e3\u670d\u52a1\u63d0\u4f9b\u8005\u8c03\u7528\u65b9\u6cd5\u65f6\u5f02\u5e38";
                break;
            }
            case -2: {
                errorMsg = "\u672a\u627e\u5230\u63a5\u53e3\u670d\u52a1\u63d0\u4f9b\u8005";
                break;
            }
            case -1: {
                errorMsg = "\u65b9\u6cd5\u8c03\u7528\u5931\u8d25(\u672a\u77e5\u5f02\u5e38)";
                break;
            }
            default: {
                errorMsg = "\u65b9\u6cd5\u8c03\u7528\u5931\u8d25(\u672a\u77e5\u5f02\u5e38)";
            }
        }
        return errorMsg;
    }

    public static String compress(String str) throws IOException {
        if (null == str || str.length() <= 0) {
            return str;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        GZIPOutputStream gzip = new GZIPOutputStream(out);
        gzip.write(str.getBytes("utf-8"));
        gzip.close();
        return out.toString("ISO-8859-1");
    }

    public static String unCompress(String str) throws IOException {
        if (null == str || str.length() <= 0) {
            return str;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayInputStream in = new ByteArrayInputStream(str.getBytes("ISO-8859-1"));
        GZIPInputStream gzip = new GZIPInputStream(in);
        byte[] buffer = new byte[256];
        int n = 0;
        while ((n = gzip.read(buffer)) >= 0) {
            out.write(buffer, 0, n);
        }
        return out.toString("utf-8");
    }
}

