package com.xdja.eoa.sdk.remote;


/**
 * @author jarlen
 * @date 2020/5/19
 * 跨进程方法调用参数
 */
public class RemoteMethodParam {

    /**
     * 方法名
     * <br>必传</br>
     *
     * @see com.xdja.eoa.sdk.remote.RemoteMethodParam
     */
    private String method;

    /**
     * 方法版本号
     * <br>非必传；默认首版本</br>
     */
    private int version;

    /**
     * 调用方身份码
     * <br>必传</br>
     */
    private String identityCode;

    /**
     * 方法调用参数
     * <br>非必传</br>
     */
    private String params;

    /**
     * 方法调用方标识
     * <br>非必传；标记使用同一个callback时的不同业务</br>
     */
    private String mark;

    public String getMethod() {
        return method;
    }

    public RemoteMethodParam setMethod(String method) {
        this.method = method;
        return this;
    }

    public int getVersion() {
        return version;
    }

    public RemoteMethodParam setVersion(int version) {
        this.version = version;
        return this;
    }

    public String getIdentityCode() {
        return identityCode;
    }

    public RemoteMethodParam setIdentityCode(String identityCode) {
        this.identityCode = identityCode;
        return this;
    }

    public String getParams() {
        return params;
    }

    public RemoteMethodParam setParams(String params) {
        this.params = params;
        return this;
    }

    public String getMark() {
        return mark;
    }

    public RemoteMethodParam setMark(String mark) {
        this.mark = mark;
        return this;
    }
}
