/*
 * Decompiled with CFR 0.152.
 */
package com.flyou.pictureselecter.adapter;

import android.content.Context;
import android.os.Parcelable;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.ProgressBar;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.flyou.pictureselecter.bean.ImageBean;
import com.flyou.pictureselecter.util.FileUtils;
import com.flyou.pictureselecter.widget.subscaleview.ImageSource;
import com.flyou.pictureselecter.widget.subscaleview.SubsamplingScaleImageView;
import com.xdja.feedbacksdk.R;
import java.util.List;

public class ChooseBigPicAdapter
extends PagerAdapter
implements SubsamplingScaleImageView.OnImageEventListener {
    private List<ImageBean> images;
    private LayoutInflater inflater;
    private Context mContext;
    private SubsamplingScaleImageView bigImageView;
    private OnPhotoTapListener onPhotoTapListener;

    public ChooseBigPicAdapter(Context context, List<ImageBean> images) {
        this.images = images;
        this.inflater = LayoutInflater.from((Context)context);
        this.mContext = context;
    }

    public void destroyItem(ViewGroup container, int position, Object object) {
        ((ViewPager)container).removeView((View)object);
    }

    public int getCount() {
        return this.images.size();
    }

    public Object instantiateItem(ViewGroup view, int position) {
        View imageLayout = this.inflater.inflate(R.layout.xdja_picture_selector_choose_big_pic_item, view, false);
        ImageView imageView = (ImageView)imageLayout.findViewById(R.id.img_pic);
        ImageBean imageBean = this.images.get(position);
        imageView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ChooseBigPicAdapter.this.onPhotoTapListener.onPhotoTap();
            }
        });
        this.bigImageView = (SubsamplingScaleImageView)imageLayout.findViewById(R.id.img_big_pic);
        ProgressBar spinner = (ProgressBar)imageLayout.findViewById(R.id.pb_loading);
        spinner.setVisibility(8);
        boolean isGif = FileUtils.getFileExtension(imageBean.getPath()).toLowerCase().equals("gif");
        if (isGif) {
            Glide.with((Context)this.mContext).load(imageBean.getPath()).asGif().placeholder(R.drawable.img_pic_big_default).error(R.drawable.img_pic_big_default).diskCacheStrategy(DiskCacheStrategy.SOURCE).into(imageView);
        } else {
            imageView.setVisibility(8);
            this.bigImageView.setVisibility(0);
            this.bigImageView.setImage(ImageSource.uri(imageBean.getPath()));
            this.bigImageView.setOnImageEventListener(this);
            this.bigImageView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    ChooseBigPicAdapter.this.onPhotoTapListener.onPhotoTap();
                }
            });
        }
        imageView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ChooseBigPicAdapter.this.onPhotoTapListener.onPhotoTap();
            }
        });
        ((ViewPager)view).addView(imageLayout, 0);
        return imageLayout;
    }

    public boolean isViewFromObject(View view, Object object) {
        return view.equals(object);
    }

    public void restoreState(Parcelable state, ClassLoader loader) {
    }

    public Parcelable saveState() {
        return null;
    }

    public void setOnPhotoTapListener(OnPhotoTapListener listener) {
        this.onPhotoTapListener = listener;
    }

    @Override
    public void onReady() {
    }

    @Override
    public void onImageLoaded() {
    }

    @Override
    public void onPreviewLoadError(Exception e) {
    }

    @Override
    public void onImageLoadError(Exception e) {
        this.bigImageView.setImage(ImageSource.resource(R.drawable.img_pic_big_default));
    }

    @Override
    public void onTileLoadError(Exception e) {
        this.bigImageView.setImage(ImageSource.resource(R.drawable.img_pic_big_default));
    }

    @Override
    public void onPreviewReleased() {
    }

    public static interface OnPhotoTapListener {
        public void onPhotoTap();
    }
}

