/*
 * Decompiled with CFR 0.152.
 */
package com.flyou.pictureselecter.adapter;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.flyou.pictureselecter.bean.ImageBean;
import com.flyou.pictureselecter.config.PictureSelectorConfig;
import com.flyou.pictureselecter.manager.ChooseChangeManager;
import com.flyou.pictureselecter.util.FileUtils;
import com.flyou.pictureselecter.util.PictureToastUtil;
import com.xdja.feedbacksdk.R;
import java.util.List;

public class ChooseChildPicAdapter
extends BaseAdapter {
    private Context mContext;
    private LayoutInflater inflater;
    private List<ImageBean> pics;
    private OnSelectedChanged onSelectedChanged;
    private PictureSelectorConfig config;

    public ChooseChildPicAdapter(Context context, String folderName, OnSelectedChanged changed) {
        this.mContext = context;
        this.inflater = LayoutInflater.from((Context)context);
        this.pics = ChooseChangeManager.getInstance().getmGroupMap().get(folderName);
        this.onSelectedChanged = changed;
        this.config = PictureSelectorConfig.getInstance();
    }

    public void refresh(String folderName) {
        this.pics = ChooseChangeManager.getInstance().getmGroupMap().get(folderName);
        this.notifyDataSetChanged();
    }

    public int getCount() {
        if (this.pics != null) {
            return this.pics.size();
        }
        return 0;
    }

    public Object getItem(int position) {
        if (this.pics != null) {
            return this.pics.get(position);
        }
        return null;
    }

    public long getItemId(int position) {
        return 0L;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        ViewHolder viewHolder = null;
        if (convertView == null) {
            convertView = this.inflater.inflate(R.layout.xdja_picture_selector_choose_pic_item, null);
            viewHolder = new ViewHolder();
            viewHolder.img = (ImageView)convertView.findViewById(R.id.img_pic);
            viewHolder.ll_click_area = (LinearLayout)convertView.findViewById(R.id.ll_click_area);
            viewHolder.cb = (CheckBox)convertView.findViewById(R.id.cb_pic);
            StateListDrawable drawable2 = new StateListDrawable();
            Drawable normal = this.mContext.getResources().getDrawable(this.config.getCheckDrawableNormal());
            Drawable press = this.mContext.getResources().getDrawable(this.config.getCheckDrawablePressed());
            drawable2.addState(new int[]{0x10100A0}, press);
            drawable2.addState(new int[0], normal);
            viewHolder.cb.setBackgroundDrawable((Drawable)drawable2);
            convertView.setTag((Object)viewHolder);
        } else {
            viewHolder = (ViewHolder)convertView.getTag();
        }
        final ImageBean imageBean = this.pics.get(position);
        viewHolder.ll_click_area.setVisibility(0);
        viewHolder.cb.setVisibility(0);
        Glide.with((Context)this.mContext).load(imageBean.getPath()).asBitmap().placeholder(R.drawable.img_pic_default).diskCacheStrategy(DiskCacheStrategy.SOURCE).error(R.drawable.img_pic_default).into(viewHolder.img);
        final CheckBox temp = viewHolder.cb;
        viewHolder.ll_click_area.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                temp.setChecked(!temp.isChecked());
            }
        });
        viewHolder.cb.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                if (ChooseChangeManager.getInstance().getChoosedCount() >= PictureSelectorConfig.getInstance().getMaxSelectCount() && isChecked && !imageBean.isSelected()) {
                    PictureToastUtil.showCountOverMaxSelect(ChooseChildPicAdapter.this.mContext);
                    temp.setChecked(false);
                    return;
                }
                if (isChecked && FileUtils.getFileSize(imageBean.getPath()) >= PictureSelectorConfig.getInstance().getMaxFileLength()) {
                    PictureToastUtil.showLengthOver(ChooseChildPicAdapter.this.mContext);
                    temp.setChecked(false);
                    return;
                }
                if (isChecked) {
                    if (!ChooseChangeManager.getmSelectedImgs().contains(imageBean)) {
                        ChooseChangeManager.getmSelectedImgs().add(imageBean);
                    }
                } else {
                    ChooseChangeManager.getmSelectedImgs().remove(imageBean);
                }
                imageBean.setSelected(isChecked);
                ChooseChildPicAdapter.this.onSelectedChanged.onChanged();
            }
        });
        viewHolder.cb.setChecked(imageBean.isSelected());
        return convertView;
    }

    public static class ViewHolder {
        public ImageView img;
        public LinearLayout ll_click_area;
        public CheckBox cb;
    }

    public static interface OnSelectedChanged {
        public void onChanged();
    }
}

