/*
 * Decompiled with CFR 0.152.
 */
package com.flyou.pictureselecter.ui;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.os.Bundle;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.view.View;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.ImageButton;
import android.widget.TextView;
import com.flyou.pictureselecter.PictureSelecter;
import com.flyou.pictureselecter.adapter.ChooseBigPicAdapter;
import com.flyou.pictureselecter.bean.ImageBean;
import com.flyou.pictureselecter.config.PictureSelectorConfig;
import com.flyou.pictureselecter.manager.ChooseChangeManager;
import com.flyou.pictureselecter.util.FileUtils;
import com.flyou.pictureselecter.util.PictureToastUtil;
import com.xdja.feedbacksdk.R;
import java.util.ArrayList;
import java.util.List;

public class ChooseBigPictureActivity
extends Activity
implements ViewPager.OnPageChangeListener,
View.OnClickListener,
CompoundButton.OnCheckedChangeListener,
ChooseBigPicAdapter.OnPhotoTapListener {
    private ViewPager vPager;
    private View titleBar;
    private ImageButton back;
    private TextView title;
    private TextView operate;
    private View cbPicFoot;
    private CheckBox cbSelected;
    private List<ImageBean> images;
    private int index;
    private String folderName;
    private PictureSelectorConfig config;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.config = PictureSelectorConfig.getInstance();
        this.getWindow().setFlags(1024, 1024);
        this.setContentView(R.layout.xdja_picture_selector_activity_choose_big_pic);
        this.initView();
        this.index = this.getIntent().getIntExtra("index", 0);
        this.folderName = this.getIntent().getStringExtra("foldername");
        this.images = ChooseChangeManager.getInstance().getmGroupMap().get(this.folderName);
        this.title.setText((CharSequence)(this.index + 1 + "/" + this.images.size()));
        this.showBottomView(this.index);
        this.cbSelected.setOnCheckedChangeListener((CompoundButton.OnCheckedChangeListener)this);
        ChooseBigPicAdapter adapter = new ChooseBigPicAdapter((Context)this, this.images);
        adapter.setOnPhotoTapListener(this);
        this.vPager.setAdapter((PagerAdapter)adapter);
        this.vPager.setCurrentItem(this.index);
        this.vPager.setOnPageChangeListener((ViewPager.OnPageChangeListener)this);
        this.back.setOnClickListener((View.OnClickListener)this);
        this.operate.setOnClickListener((View.OnClickListener)this);
    }

    private void initView() {
        this.vPager = (ViewPager)this.findViewById(R.id.vPager);
        this.titleBar = this.findViewById(R.id.title_bar);
        this.back = (ImageButton)this.findViewById(R.id.imgbtn_back);
        this.title = (TextView)this.findViewById(R.id.tv_title);
        this.operate = (TextView)this.findViewById(R.id.tv_operate);
        this.vPager = (ViewPager)this.findViewById(R.id.vPager);
        this.cbPicFoot = this.findViewById(R.id.cb_pic_foot);
        this.cbSelected = (CheckBox)this.findViewById(R.id.cb_select);
        StateListDrawable drawable2 = new StateListDrawable();
        Drawable normal = this.getResources().getDrawable(this.config.getCheckDrawableNormal());
        Drawable press = this.getResources().getDrawable(this.config.getCheckDrawablePressed());
        drawable2.addState(new int[]{0x10100A0}, press);
        drawable2.addState(new int[0], normal);
        this.cbSelected.setCompoundDrawablesWithIntrinsicBounds((Drawable)drawable2, null, null, null);
    }

    protected void onResume() {
        super.onResume();
        int selectedCount = ChooseChangeManager.getInstance().getChoosedCount();
        if (selectedCount != 0) {
            this.operate.setText((CharSequence)("\u5b8c\u6210(" + selectedCount + "/" + PictureSelectorConfig.getInstance().getMaxSelectCount() + ")"));
        } else {
            this.operate.setText((CharSequence)"\u5b8c\u6210");
        }
    }

    public void onChanged() {
        int selectedCount = ChooseChangeManager.getInstance().getChoosedCount();
        if (selectedCount == 0) {
            this.operate.setText((CharSequence)"\u5b8c\u6210");
        } else {
            this.operate.setText((CharSequence)("\u5b8c\u6210(" + selectedCount + "/" + PictureSelectorConfig.getInstance().getMaxSelectCount() + ")"));
        }
    }

    public void showBottomView(int position) {
        if (this.titleBar.getVisibility() != 0) {
            this.cbPicFoot.setVisibility(8);
        } else {
            this.cbPicFoot.setVisibility(0);
        }
        if (this.images.get(position).isSelected()) {
            this.cbSelected.setChecked(true);
        } else {
            this.cbSelected.setChecked(false);
        }
    }

    public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
    }

    public void onPageSelected(int position) {
        this.title.setText((CharSequence)(position + 1 + "/" + this.images.size()));
        this.index = position;
        this.showBottomView(this.index);
    }

    public void onPageScrollStateChanged(int state) {
    }

    public void onClick(View v) {
        int i = v.getId();
        if (i == R.id.tv_operate) {
            ArrayList<ImageBean> tempImgs = ChooseChangeManager.getInstance().getChoosedImg();
            ArrayList<String> imagePathList = new ArrayList<String>();
            if (tempImgs != null && tempImgs.size() > 0) {
                for (ImageBean tempImg : tempImgs) {
                    imagePathList.add(tempImg.getPath());
                }
                Intent mIntent = new Intent();
                mIntent.putExtra(PictureSelecter.INTENT_PICTURES_RESULT, imagePathList);
                this.setResult(-1, mIntent);
                this.finish();
            } else {
                ImageBean imageBean = ChooseChangeManager.getInstance().getmGroupMap().get(this.folderName).get(this.vPager.getCurrentItem());
                if (FileUtils.isFileExist(imageBean.getPath())) {
                    if (tempImgs == null) {
                        tempImgs = new ArrayList();
                    }
                    imagePathList.add(imageBean.getPath());
                    Intent mIntent = new Intent();
                    mIntent.putExtra(PictureSelecter.INTENT_PICTURES_RESULT, imagePathList);
                    this.setResult(-1, mIntent);
                    this.finish();
                } else {
                    PictureToastUtil.toast((Context)this, this.getString(R.string.pic_invalid));
                }
            }
        } else if (i == R.id.imgbtn_back) {
            this.finish();
        }
    }

    public void onCheckedChanged(CompoundButton compoundButton, boolean isChecked) {
        int i = compoundButton.getId();
        if (i == R.id.cb_select) {
            if (ChooseChangeManager.getInstance().getChoosedCount() >= PictureSelectorConfig.getInstance().getMaxSelectCount() && isChecked && !this.images.get(this.index).isSelected()) {
                PictureToastUtil.showCountOverMaxSelect(this.getApplicationContext());
                this.cbSelected.setChecked(false);
                return;
            }
            if (FileUtils.getFileSize(this.images.get(this.index).getPath()) >= PictureSelectorConfig.getInstance().getMaxFileLength()) {
                PictureToastUtil.showLengthOver(this.getApplicationContext());
                this.cbSelected.setChecked(false);
                return;
            }
            if (isChecked) {
                ChooseChangeManager.getmSelectedImgs().add(this.images.get(this.index));
            } else {
                ChooseChangeManager.getmSelectedImgs().remove(this.images.get(this.index));
            }
            this.images.get(this.index).setSelected(isChecked);
            this.onChanged();
        }
    }

    @Override
    public void onPhotoTap() {
        if (this.titleBar.getVisibility() == 0) {
            this.titleBar.setVisibility(8);
            this.cbPicFoot.setVisibility(8);
        } else {
            this.titleBar.setVisibility(0);
            this.cbPicFoot.setVisibility(0);
        }
    }
}

