/*
 * Decompiled with CFR 0.152.
 */
package com.flyou.pictureselecter.ui;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.widget.AdapterView;
import android.widget.GridView;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.flyou.pictureselecter.PictureSelecter;
import com.flyou.pictureselecter.adapter.ChooseChildPicAdapter;
import com.flyou.pictureselecter.adapter.ChooseGroupPicAdapter;
import com.flyou.pictureselecter.bean.ImageBean;
import com.flyou.pictureselecter.bean.ImageGroupBean;
import com.flyou.pictureselecter.config.PictureSelectorConfig;
import com.flyou.pictureselecter.manager.ChooseChangeManager;
import com.flyou.pictureselecter.persenter.GetImagePersenter;
import com.flyou.pictureselecter.ui.ChooseBigPictureActivity;
import com.flyou.pictureselecter.util.ListUtil;
import com.flyou.pictureselecter.util.PictureToastUtil;
import com.flyou.pictureselecter.util.StatusBarCompat;
import com.flyou.pictureselecter.view.IGetImageView;
import com.xdja.feedbacksdk.R;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ChoosePictureActivity
extends Activity
implements View.OnClickListener,
ChooseChildPicAdapter.OnSelectedChanged,
IGetImageView {
    public static final String TAG = "ChoosePictureActivity";
    private GridView gv_content;
    private ListView lv_content;
    private LinearLayout ll_click_area;
    private ProgressBar pb_loading;
    private ImageButton back;
    private TextView title;
    private TextView operate;
    private RelativeLayout title_bar;
    private ChooseGroupPicAdapter groupPicAdapter;
    private ChooseChildPicAdapter childPicAdapter;
    private Map<String, ArrayList<ImageBean>> mGroupMap;
    private List<ImageGroupBean> list;
    public static final String SELECTED_IMGS = "selectedImgs";
    private static final int REQUEST_CODE = 4096;
    private GetImagePersenter getimagePersenter;
    private ArrayList<ImageBean> selectedPicture;
    private PictureSelectorConfig config;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.xdja_picture_selector_activity_choose_pic);
        ArrayList imagePath = (ArrayList)this.getIntent().getSerializableExtra(PictureSelecter.INTENT_PICTURES_RESULT);
        if (imagePath != null && imagePath.size() > 0) {
            this.selectedPicture = new ArrayList();
            for (String s : imagePath) {
                this.selectedPicture.add(new ImageBean(s, true));
            }
        }
        this.config = PictureSelectorConfig.getInstance();
        this.initView();
        ChooseChangeManager.getInstance().init();
        this.getimagePersenter = new GetImagePersenter(this, this.getApplicationContext());
        this.getimagePersenter.getImages(PictureSelectorConfig.getInstance().isShowGif());
        this.lv_content.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                if (ChoosePictureActivity.this.groupPicAdapter.getCurrentSelected() == position) {
                    return;
                }
                ChoosePictureActivity.this.title.setText((CharSequence)((ImageGroupBean)ChoosePictureActivity.this.list.get(position)).getFolderName());
                ChoosePictureActivity.this.title.setCompoundDrawablesWithIntrinsicBounds(0, 0, R.drawable.icon_arrow_down, 0);
                ChoosePictureActivity.this.childPicAdapter.refresh(((ImageGroupBean)ChoosePictureActivity.this.list.get(position)).getFolderName());
                ChoosePictureActivity.this.ll_click_area.setVisibility(8);
                ChoosePictureActivity.this.groupPicAdapter.setCurrentSelected(position);
                ChoosePictureActivity.this.groupPicAdapter.refresh();
            }
        });
        this.gv_content.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                Intent mIntent = new Intent((Context)ChoosePictureActivity.this, ChooseBigPictureActivity.class);
                mIntent.putExtra("index", position);
                mIntent.putExtra("foldername", ((ImageGroupBean)ChoosePictureActivity.this.list.get(ChoosePictureActivity.this.groupPicAdapter.getCurrentSelected())).getFolderName());
                ChoosePictureActivity.this.startActivityForResult(mIntent, 4096);
            }
        });
        this.title.setCompoundDrawablesWithIntrinsicBounds(0, 0, R.drawable.icon_arrow_down, 0);
        this.title.setCompoundDrawablePadding(this.getResources().getDimensionPixelSize(R.dimen.picture_selector_padding_16));
        this.title.setOnClickListener((View.OnClickListener)this);
        this.back.setOnClickListener((View.OnClickListener)this);
        this.operate.setVisibility(0);
        this.operate.setOnClickListener((View.OnClickListener)this);
        this.ll_click_area.setOnClickListener((View.OnClickListener)this);
    }

    private void initView() {
        this.title_bar = (RelativeLayout)this.findViewById(R.id.title_bar);
        this.pb_loading = (ProgressBar)this.findViewById(R.id.pb_loading);
        this.ll_click_area = (LinearLayout)this.findViewById(R.id.ll_click_area);
        this.lv_content = (ListView)this.findViewById(R.id.lv_pics);
        this.gv_content = (GridView)this.findViewById(R.id.gv_pics);
        this.back = (ImageButton)this.findViewById(R.id.imgbtn_back);
        this.title = (TextView)this.findViewById(R.id.tv_title);
        this.operate = (TextView)this.findViewById(R.id.tv_operate);
        this.title_bar.setBackgroundColor(this.config.getTitleBarBgColor());
        StatusBarCompat.compat(this, this.config.getStatusBarColor());
        if (Build.VERSION.SDK_INT >= 19 && Build.VERSION.SDK_INT < 21) {
            this.getWindow().addFlags(0x4000000);
        }
    }

    protected void onResume() {
        super.onResume();
        int selectedCount = ChooseChangeManager.getInstance().getChoosedCount();
        if (selectedCount != 0) {
            this.operate.setText((CharSequence)("\u5b8c\u6210(" + selectedCount + "/" + this.config.getMaxSelectCount() + ")"));
        }
        if (this.list != null) {
            this.childPicAdapter.refresh(this.list.get(this.groupPicAdapter.getCurrentSelected()).getFolderName());
        }
    }

    private List<ImageGroupBean> subGroupOfImage(Map<String, ArrayList<ImageBean>> mGruopMap) {
        if (this.mGroupMap == null) {
            return null;
        }
        if (mGruopMap.size() == 0) {
            return null;
        }
        ArrayList<ImageGroupBean> list = new ArrayList<ImageGroupBean>();
        for (Map.Entry<String, ArrayList<ImageBean>> entry : mGruopMap.entrySet()) {
            String key = entry.getKey();
            List value = entry.getValue();
            if (value == null || value.size() <= 0) continue;
            ImageGroupBean mImageBean = new ImageGroupBean();
            mImageBean.setFolderName(key);
            mImageBean.setImageCounts(value.size());
            mImageBean.setTopImagePath(((ImageBean)value.get(0)).getPath());
            if (TextUtils.equals((CharSequence)this.getString(R.string.all_picture), (CharSequence)key) || TextUtils.equals((CharSequence)this.getString(R.string.all_video), (CharSequence)key)) {
                list.add(0, mImageBean);
                continue;
            }
            list.add(mImageBean);
        }
        return list;
    }

    public void onClick(View v) {
        int i = v.getId();
        if (i == R.id.tv_title) {
            if (this.ll_click_area.getVisibility() != 0) {
                this.ll_click_area.setVisibility(0);
                this.title.setCompoundDrawablesWithIntrinsicBounds(0, 0, R.drawable.icon_arrow_up, 0);
            } else {
                this.ll_click_area.setVisibility(8);
                this.title.setCompoundDrawablesWithIntrinsicBounds(0, 0, R.drawable.icon_arrow_down, 0);
            }
        } else if (i == R.id.tv_operate) {
            ArrayList<ImageBean> tempImgs = ChooseChangeManager.getInstance().getChoosedImg();
            ArrayList<String> imagePathList = new ArrayList<String>();
            if (tempImgs != null && tempImgs.size() > 0) {
                for (ImageBean tempImg : tempImgs) {
                    imagePathList.add(tempImg.getPath());
                }
                Intent mIntent = new Intent();
                mIntent.putExtra(PictureSelecter.INTENT_PICTURES_RESULT, imagePathList);
                this.setResult(-1, mIntent);
                this.finish();
            }
        } else if (i == R.id.imgbtn_back) {
            this.finish();
        } else if (i == R.id.ll_click_area) {
            this.ll_click_area.setVisibility(8);
            this.title.setCompoundDrawablesWithIntrinsicBounds(0, 0, R.drawable.icon_arrow_down, 0);
        }
    }

    @Override
    public void showLoading() {
        this.pb_loading.setVisibility(0);
    }

    @Override
    public void hideLoading() {
        this.pb_loading.setVisibility(8);
    }

    @Override
    public void showError(String msg) {
        PictureToastUtil.toast((Context)this, msg);
    }

    @Override
    public void onGetImages(Map<String, ArrayList<ImageBean>> images) {
        this.mGroupMap = images;
        ChooseChangeManager.getInstance().setmGroupMap(this.mGroupMap);
        if (this.selectedPicture != null && this.selectedPicture.size() > 0) {
            ChooseChangeManager.getInstance().setSelectPic(this.selectedPicture);
            this.onChanged();
        }
        this.list = this.subGroupOfImage(this.mGroupMap);
        this.groupPicAdapter = new ChooseGroupPicAdapter((Context)this, this.list, false);
        this.lv_content.setAdapter((ListAdapter)this.groupPicAdapter);
        this.groupPicAdapter.setCurrentSelected(0);
        this.groupPicAdapter.refresh();
        if (!ListUtil.isEmpty(this.list)) {
            this.title.setText((CharSequence)this.list.get(0).getFolderName());
            this.childPicAdapter = new ChooseChildPicAdapter((Context)this, this.list.get(0).getFolderName(), this);
            this.gv_content.setAdapter((ListAdapter)this.childPicAdapter);
        } else {
            this.title.setText((CharSequence)"\u76f8\u518c\u91cc\u6ca1\u6709\u56fe\u50cf");
            this.childPicAdapter = new ChooseChildPicAdapter((Context)this, null, this);
            this.gv_content.setAdapter((ListAdapter)this.childPicAdapter);
        }
    }

    @Override
    public void onChanged() {
        int selectedCount = ChooseChangeManager.getInstance().getChoosedCount();
        if (selectedCount == 0) {
            this.operate.setText((CharSequence)"");
        } else {
            this.operate.setText((CharSequence)("\u5b8c\u6210(" + selectedCount + "/" + this.config.getMaxSelectCount() + ")"));
        }
    }

    protected void onDestroy() {
        super.onDestroy();
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == 4096 && resultCode == -1 && data != null) {
            Intent mIntent = new Intent();
            mIntent.putExtra(PictureSelecter.INTENT_PICTURES_RESULT, data.getSerializableExtra(PictureSelecter.INTENT_PICTURES_RESULT));
            this.setResult(-1, mIntent);
            this.finish();
        }
    }
}

