/*
 * Decompiled with CFR 0.152.
 */
package com.flyou.pictureselecter.util;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.graphics.Color;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;

public class StatusBarCompat {
    private static final int INVALID_VAL = -1;
    private static final int COLOR_DEFAULT = Color.parseColor((String)"#20000000");

    @TargetApi(value=21)
    public static void compat(Activity activity, int statusColor) {
        if (Build.VERSION.SDK_INT >= 21) {
            if (statusColor != -1) {
                activity.getWindow().setStatusBarColor(statusColor);
            }
            return;
        }
        if (Build.VERSION.SDK_INT >= 19 && Build.VERSION.SDK_INT < 21) {
            View statusBarView;
            int color = COLOR_DEFAULT;
            ViewGroup contentView = (ViewGroup)activity.findViewById(0x1020002);
            if (statusColor != -1) {
                color = statusColor;
            }
            if ((statusBarView = contentView.getChildAt(0)) != null && statusBarView.getMeasuredHeight() == StatusBarCompat.getStatusBarHeight((Context)activity)) {
                statusBarView.setBackgroundColor(color);
                return;
            }
            statusBarView = new View((Context)activity);
            ViewGroup.LayoutParams lp = new ViewGroup.LayoutParams(-1, StatusBarCompat.getStatusBarHeight((Context)activity));
            statusBarView.setBackgroundColor(color);
            contentView.addView(statusBarView, lp);
        }
    }

    public static void compat(Activity activity) {
        StatusBarCompat.compat(activity, -1);
    }

    public static int getStatusBarHeight(Context context) {
        int result = 0;
        int resourceId = context.getResources().getIdentifier("status_bar_height", "dimen", "android");
        if (resourceId > 0) {
            result = context.getResources().getDimensionPixelSize(resourceId);
        }
        return result;
    }
}

