/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.feedbacksdk.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.TextView;
import com.xdja.feedbacklibrary.FeedBackManager;
import com.xdja.feedbacklibrary.bean.comment.FeedBackCommentBeen;
import com.xdja.feedbacklibrary.util.DateUtil;
import com.xdja.feedbacksdk.R;
import java.util.List;

public class FeedBackCommentAdapterV4
extends BaseAdapter {
    private LayoutInflater inflater;
    private List<FeedBackCommentBeen> feedBackCommentBeenList;
    private String feedBackUserId;
    private Context context;

    public FeedBackCommentAdapterV4(List<FeedBackCommentBeen> feedBackCommentBeenList, String feedBackUserId, Context context) {
        this.feedBackCommentBeenList = feedBackCommentBeenList;
        this.inflater = LayoutInflater.from((Context)context);
        this.feedBackUserId = feedBackUserId;
        this.context = context;
    }

    public int getCount() {
        return this.feedBackCommentBeenList.size();
    }

    public Object getItem(int position) {
        return this.feedBackCommentBeenList == null ? null : this.feedBackCommentBeenList.get(position);
    }

    public long getItemId(int position) {
        return 0L;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        FeedBackCommentBeen feedBackCommentBeen = this.feedBackCommentBeenList.get(position);
        ViewHolder holder = new ViewHolder();
        String currentUser = FeedBackManager.getInstance().getUserId();
        if (currentUser.equals(feedBackCommentBeen.getReplyUserId())) {
            convertView = this.inflater.inflate(R.layout.xdja_feed_back_comment_list_item_v4, null);
            holder.tvfeedbackcontent = (TextView)convertView.findViewById(R.id.tv_feed_back_content);
            holder.tvfeedbacktime = (TextView)convertView.findViewById(R.id.tv_feedback_time);
            holder.tvfeedbacktype = (TextView)convertView.findViewById(R.id.tv_feedback_type);
        } else {
            convertView = this.inflater.inflate(R.layout.xdja_feed_back_comment_list_item_left_v4, null);
            holder.tvfeedbackcontent = (TextView)convertView.findViewById(R.id.tv_feed_back_content);
            holder.tvfeedbacktime = (TextView)convertView.findViewById(R.id.tv_feedback_time);
            holder.tvfeedbacktype = (TextView)convertView.findViewById(R.id.tv_feedback_type);
        }
        convertView.setTag((Object)holder);
        if (feedBackCommentBeen.getReplySourceType().equals("3")) {
            holder.tvfeedbacktype.setText((CharSequence)feedBackCommentBeen.getReplyUserName());
        } else if (this.feedBackUserId.equals(feedBackCommentBeen.getReplyUserId())) {
            holder.tvfeedbacktype.setText((CharSequence)"\u6211");
            holder.tvfeedbacktype.setVisibility(8);
        } else {
            holder.tvfeedbacktype.setText((CharSequence)feedBackCommentBeen.getReplyUserName());
        }
        holder.tvfeedbackcontent.setText((CharSequence)feedBackCommentBeen.getContent());
        holder.tvfeedbacktime.setText((CharSequence)DateUtil.getTimeStringFromNow((long)feedBackCommentBeen.getReplyTimestamp()));
        return convertView;
    }

    static class ViewHolder {
        private TextView tvfeedbackcontent;
        private TextView tvfeedbacktime;
        private TextView tvfeedbacktype;

        ViewHolder() {
        }
    }
}

