/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.feedbacksdk.adapter;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.TextView;
import com.xdja.feedbacklibrary.bean.feedback.GetFeedBackListResBean;
import com.xdja.feedbacklibrary.util.DateUtil;
import com.xdja.feedbacksdk.R;
import com.xdja.feedbacksdk.ui.FeedBackDetailActivityV4;
import java.io.Serializable;
import java.util.List;

public class FeedbackAdapter
extends BaseAdapter {
    public static final String FEED_BACK_BEAN = "feed_back_bean";
    private List<GetFeedBackListResBean> data;
    private Activity context;
    private LayoutInflater inflater;

    public FeedbackAdapter(Activity contetxt, List<GetFeedBackListResBean> data) {
        this.data = data;
        this.context = contetxt;
        this.inflater = LayoutInflater.from((Context)contetxt);
    }

    public int getCount() {
        return this.data == null || this.data.size() == 0 ? 0 : this.data.size();
    }

    public Object getItem(int position) {
        return this.data == null ? null : this.data.get(position);
    }

    public long getItemId(int position) {
        return position;
    }

    public View getView(final int position, View convertView, ViewGroup parent) {
        GetFeedBackListResBean feedback = this.data.get(position);
        ViewHolder viewHolder = null;
        if (convertView == null) {
            convertView = this.inflater.inflate(R.layout.feed_back_history_item, parent, false);
            viewHolder = new ViewHolder();
            viewHolder.time = (TextView)convertView.findViewById(R.id.feed_back_time);
            viewHolder.description = (TextView)convertView.findViewById(R.id.feed_back_title);
            viewHolder.new_message_img = (ImageView)convertView.findViewById(R.id.new_message_img);
            convertView.setTag((Object)viewHolder);
        } else {
            viewHolder = (ViewHolder)convertView.getTag();
        }
        if (feedback.getIsUnread().equals("1")) {
            viewHolder.new_message_img.setVisibility(0);
        } else {
            viewHolder.new_message_img.setVisibility(8);
        }
        viewHolder.time.setText((CharSequence)DateUtil.getTimeStringFromNow((long)feedback.getFeedbackTimestamp()));
        viewHolder.description.setText((CharSequence)feedback.getOptionsDesc());
        convertView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Intent intent = new Intent((Context)FeedbackAdapter.this.context, FeedBackDetailActivityV4.class);
                intent.putExtra(FeedbackAdapter.FEED_BACK_BEAN, (Serializable)FeedbackAdapter.this.data.get(position));
                FeedbackAdapter.this.context.startActivityForResult(intent, 1);
            }
        });
        return convertView;
    }

    static class ViewHolder {
        TextView time;
        TextView description;
        ImageView new_message_img;

        ViewHolder() {
        }
    }
}

