/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.feedbacksdk.adapter;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.Button;
import android.widget.ImageView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.xdja.feedbacksdk.R;
import com.xdja.feedbacksdk.ui.FeedBackPicturePreviewActivity;
import java.util.ArrayList;
import java.util.List;

public class ImageGirdAdapter
extends BaseAdapter {
    private Activity mContext;
    private ArrayList<String> mImageUrlList;
    private OnDelListener delListener;
    private OnAddImageListener addImageListener;
    private boolean showDelBtn = false;
    public static final String ADD_IMAGE_TAG = "" + R.drawable.xdja_feed_back_add_img_btn_selector;

    public ImageGirdAdapter(Activity context, List<String> mImageUrlList) {
        this.mContext = context;
        this.mImageUrlList = (ArrayList)mImageUrlList;
    }

    public void setData(ArrayList<String> urls) {
        this.mImageUrlList = urls;
    }

    public void showDelBtn(boolean show) {
        this.showDelBtn = show;
    }

    public void setOnDelListener(OnDelListener listener) {
        this.delListener = listener;
    }

    public void setOnAddImageListener(OnAddImageListener listener) {
        this.addImageListener = listener;
    }

    public int getCount() {
        return this.mImageUrlList.size();
    }

    public Object getItem(int position) {
        return this.mImageUrlList.get(position);
    }

    public long getItemId(int position) {
        return 0L;
    }

    public View getView(final int position, View convertView, ViewGroup parent) {
        ViewHolder holder;
        if (null == convertView) {
            holder = new ViewHolder();
            convertView = LayoutInflater.from((Context)this.mContext).inflate(R.layout.xdja_feed_back_grid_image_item, null);
            holder.imageView = (ImageView)convertView.findViewById(R.id.iv_feed_back_item);
            holder.delBtn = (Button)convertView.findViewById(R.id.delBtn);
            convertView.setTag((Object)holder);
        } else {
            holder = (ViewHolder)convertView.getTag();
        }
        holder.delBtn.setVisibility(this.showDelBtn ? 0 : 8);
        holder.delBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (null != ImageGirdAdapter.this.delListener) {
                    ImageGirdAdapter.this.delListener.OnDel((String)ImageGirdAdapter.this.mImageUrlList.get(position), position);
                }
            }
        });
        if (this.mImageUrlList.get(position).equalsIgnoreCase(ADD_IMAGE_TAG)) {
            holder.delBtn.setVisibility(8);
            holder.imageView.setImageResource(R.drawable.xdja_feed_back_add_img_btn_selector);
            holder.imageView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (null != ImageGirdAdapter.this.addImageListener) {
                        ImageGirdAdapter.this.addImageListener.onAddImage();
                    }
                }
            });
        } else {
            holder.imageView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    Intent intent = new Intent((Context)ImageGirdAdapter.this.mContext, FeedBackPicturePreviewActivity.class);
                    if (ImageGirdAdapter.this.showDelBtn) {
                        ArrayList tmpList = new ArrayList(ImageGirdAdapter.this.mImageUrlList.subList(0, ImageGirdAdapter.this.mImageUrlList.size() - 1));
                        intent.putStringArrayListExtra("image_list", tmpList);
                    } else {
                        intent.putStringArrayListExtra("image_list", ImageGirdAdapter.this.mImageUrlList);
                    }
                    intent.putExtra("index", position);
                    ImageGirdAdapter.this.mContext.startActivity(intent);
                }
            });
            Glide.with((Activity)this.mContext).load(this.mImageUrlList.get(position)).placeholder(R.drawable.img_pic_default).error(R.drawable.img_pic_default).diskCacheStrategy(DiskCacheStrategy.ALL).centerCrop().into(holder.imageView);
        }
        return convertView;
    }

    public static interface OnAddImageListener {
        public void onAddImage();
    }

    public static interface OnDelListener {
        public void OnDel(String var1, int var2);
    }

    public class ViewHolder {
        private ImageView imageView;
        private Button delBtn;
    }
}

