/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.feedbacksdk.base;

import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.Toolbar;
import android.text.TextUtils;
import android.view.MenuItem;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.Toast;
import com.flyou.pictureselecter.widget.JXProgressDialog;
import com.xdja.feedbacksdk.R;
import com.xdja.feedbacksdk.base.IBaseView;

public abstract class BaseActivity
extends AppCompatActivity
implements IBaseView,
Toolbar.OnMenuItemClickListener {
    private JXProgressDialog dialog = null;
    protected Toolbar toolbar;
    private DialogInterface.OnCancelListener cancelListener = new DialogInterface.OnCancelListener(){

        public void onCancel(DialogInterface dialog) {
            BaseActivity.this.dismissLoading();
            BaseActivity.this.onProgressCancel();
        }
    };

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.attachView(savedInstanceState);
        this.initToolbar();
        this.initView(savedInstanceState);
    }

    protected abstract void attachView(@Nullable Bundle var1);

    protected void initView(@Nullable Bundle savedInstanceState) {
    }

    private void initToolbar() {
        this.toolbar = (Toolbar)this.findViewById(R.id.toolbar);
        if (this.toolbar == null) {
            return;
        }
        if (this.getSupportActionBar() == null) {
            this.setSupportActionBar(this.toolbar);
            this.toolbar.setNavigationIcon(R.drawable.btn_back);
            this.toolbar.setNavigationOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    BaseActivity.this.finish();
                }
            });
            this.toolbar.setOnMenuItemClickListener((Toolbar.OnMenuItemClickListener)this);
        }
    }

    protected void onDestroy() {
        super.onDestroy();
    }

    @Override
    public void showError(String msg) {
        if (!TextUtils.isEmpty((CharSequence)msg)) {
            this.showToast(msg);
        }
    }

    public void showToast(String msg) {
        Toast.makeText((Context)this, (CharSequence)msg, (int)0).show();
    }

    @Override
    public void showLoading(String msg) {
        if (this.dialog == null) {
            this.dialog = new JXProgressDialog();
        }
        this.dialog.show((Context)this, msg, this.cancelListener);
    }

    public void showLoading(String msg, boolean cancelable) {
        if (this.dialog == null) {
            this.dialog = new JXProgressDialog();
        }
        this.dialog.show((Context)this, msg, cancelable, cancelable, this.cancelListener);
    }

    @Override
    public void dismissLoading() {
        if (this.dialog != null) {
            this.dialog.dismiss();
            this.dialog = null;
        }
    }

    protected void onProgressCancel() {
    }

    protected void startMyActivity(Class clazz, Bundle bundle) {
        Intent intent = new Intent((Context)this, clazz);
        if (bundle != null) {
            intent.putExtras(bundle);
        }
        this.startActivity(intent);
    }

    public void hideKeyboard(View v) {
        ((InputMethodManager)this.getSystemService("input_method")).hideSoftInputFromWindow(v.getWindowToken(), 2);
    }

    public void hideKeyboard() {
        this.hideKeyboard(this.getWindow().getDecorView());
    }

    public void showKeyboard(EditText et) {
        ((InputMethodManager)this.getSystemService("input_method")).showSoftInput((View)et, 1);
    }

    public boolean onMenuItemClick(MenuItem item) {
        return false;
    }
}

