/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.feedbacksdk.presenter;

import com.xdja.feedbacklibrary.bean.feedback.GetFeedBackListResBean;
import com.xdja.feedbacklibrary.callback.RequestCallBack;
import com.xdja.feedbacklibrary.http.bean.ResponseBean;
import com.xdja.feedbacksdk.model.IFeedbackModel;
import com.xdja.feedbacksdk.model.impl.FeedbackModel;
import com.xdja.feedbacksdk.view.IFeedbackView;
import java.util.List;

public class FeedbackPresenter {
    private IFeedbackView<ResponseBean<List<GetFeedBackListResBean>>> feedbackView;
    private IFeedbackModel<RequestCallBack<ResponseBean<List<GetFeedBackListResBean>>>> feedbackModel;
    public static final int PULL_TO_REFRESH = 1;
    public static final int LOAD_MORE = 2;

    public FeedbackPresenter(IFeedbackView<ResponseBean<List<GetFeedBackListResBean>>> feedbackView) {
        this.feedbackView = feedbackView;
        this.feedbackModel = new FeedbackModel();
    }

    public void pullDown2Refrush(String userId, String packageName, long startTime) {
        this.feedbackModel.loadFeedbackList(userId, packageName, startTime, -1L, new RequestCallBack<ResponseBean<List<GetFeedBackListResBean>>>(){

            public void onSuccess(ResponseBean<List<GetFeedBackListResBean>> info) {
                FeedbackPresenter.this.handleSuccess((ResponseBean<List<GetFeedBackListResBean>>)info, 1);
            }

            public void onFailure(String error) {
                FeedbackPresenter.this.handleFailure(error);
            }
        });
    }

    public void loadMore(String userId, String packageName, long endTime) {
        this.feedbackModel.loadFeedbackList(userId, packageName, -1L, endTime, new RequestCallBack<ResponseBean<List<GetFeedBackListResBean>>>(){

            public void onSuccess(ResponseBean<List<GetFeedBackListResBean>> info) {
                FeedbackPresenter.this.handleSuccess((ResponseBean<List<GetFeedBackListResBean>>)info, 2);
            }

            public void onFailure(String error) {
                FeedbackPresenter.this.handleFailure(error);
            }
        });
    }

    private void handleSuccess(ResponseBean<List<GetFeedBackListResBean>> info, int operate) {
        if (info.getData() == null || ((List)info.getData()).isEmpty()) {
            this.feedbackView.showEmpty();
        } else {
            this.feedbackView.success(info, operate);
        }
    }

    private void handleFailure(String error) {
        this.feedbackView.showError(error);
    }
}

