/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.feedbacksdk.presenter;

import com.xdja.feedbacklibrary.bean.comment.FeedBackCommentBeen;
import com.xdja.feedbacklibrary.bean.feedback.GetFeedBackListResBean;
import com.xdja.feedbacklibrary.callback.RequestCallBack;
import com.xdja.feedbacklibrary.http.bean.ResponseBean;
import com.xdja.feedbacksdk.model.IGetCommentModel;
import com.xdja.feedbacksdk.model.impl.GetCommentModel;
import com.xdja.feedbacksdk.view.IAddCommentViewV4;
import com.xdja.feedbacksdk.view.IGetCommentView;
import java.util.List;

public class GetCommentPresenter
implements RequestCallBack<ResponseBean<List<FeedBackCommentBeen>>> {
    private IGetCommentModel getCommentModel;
    private IGetCommentView getCommentView;
    private boolean showLoading = false;

    public GetCommentPresenter(IGetCommentView getFeedBackCommentView) {
        this.getCommentView = getFeedBackCommentView;
        this.getCommentModel = new GetCommentModel();
    }

    public void getFeedBackCommentList(String feedBackId, long startTime, long endTime) {
        this.getFeedBackCommentList(feedBackId, startTime, endTime, false);
    }

    public void getFeedBackCommentList(String feedBackId, long startTime, long endTime, boolean showLoading) {
        this.showLoading = showLoading;
        if (showLoading) {
            this.getCommentView.showGetCommentLoading();
        }
        this.getCommentModel.getCommentList(feedBackId, startTime, endTime, this);
    }

    public void getFeedBackComment(String feedBackId, boolean showLoading) {
        this.showLoading = showLoading;
        if (showLoading) {
            this.getCommentView.showGetCommentLoading();
        }
        this.getCommentModel.getComment(feedBackId, new RequestCallBack<GetFeedBackListResBean>(){

            public void onSuccess(GetFeedBackListResBean getFeedBackListResBean) {
                GetCommentPresenter.this.getCommentView.hideGetCommentLoading();
                if (GetCommentPresenter.this.getCommentView != null && GetCommentPresenter.this.getCommentView instanceof IAddCommentViewV4) {
                    ((IAddCommentViewV4)((Object)GetCommentPresenter.this.getCommentView)).onCommentDetail(getFeedBackListResBean);
                }
            }

            public void onFailure(String s) {
                this.onFailure(s);
            }
        });
    }

    public void onSuccess(ResponseBean<List<FeedBackCommentBeen>> responseBean) {
        if (this.showLoading) {
            this.getCommentView.hideGetCommentLoading();
        }
        if (responseBean == null) {
            this.getCommentView.showEmpty();
            return;
        }
        List feedBackCommentBeenList = (List)responseBean.getData();
        if (feedBackCommentBeenList == null || feedBackCommentBeenList.size() == 0) {
            this.getCommentView.showEmpty();
        } else {
            this.getCommentView.onGetComment(feedBackCommentBeenList, responseBean.getTotal(), responseBean.isLastPage());
        }
    }

    public void onFailure(String error) {
        if (this.showLoading) {
            this.getCommentView.hideGetCommentLoading();
        }
        this.getCommentView.showError(error);
    }
}

