/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.feedbacksdk.ui;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.widget.SwipeRefreshLayout;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import android.widget.Toast;
import com.xdja.feedbacklibrary.FeedBackManager;
import com.xdja.feedbacklibrary.bean.comment.FeedBackCommentBeen;
import com.xdja.feedbacklibrary.bean.feedback.GetFeedBackListResBean;
import com.xdja.feedbacklibrary.util.DateUtil;
import com.xdja.feedbacksdk.R;
import com.xdja.feedbacksdk.adapter.FeedBackCommentAdapter;
import com.xdja.feedbacksdk.adapter.ImageGirdInListAdapter;
import com.xdja.feedbacksdk.base.BaseActivity;
import com.xdja.feedbacksdk.presenter.AddCommentPresenter;
import com.xdja.feedbacksdk.presenter.GetCommentPresenter;
import com.xdja.feedbacksdk.view.IAddCommentView;
import com.xdja.feedbacksdk.view.IGetCommentView;
import com.xdja.feedbacksdk.widget.MySwipeRefreshLayout;
import com.xdja.feedbacksdk.widget.NoScrollGridView;
import java.util.ArrayList;
import java.util.List;

public class FeedBackDetailActivity
extends BaseActivity
implements IGetCommentView,
SwipeRefreshLayout.OnRefreshListener,
MySwipeRefreshLayout.OnLoadListener,
IAddCommentView,
View.OnClickListener {
    private ListView listView;
    private EditText bottomComment;
    private Button bottomSubmit;
    private GetFeedBackListResBean feedBackResponeBean;
    private MySwipeRefreshLayout mySwipeRefreshLayout;
    private ArrayList<FeedBackCommentBeen> feedBackCommentList = new ArrayList();
    private View headLayout;
    int measuredCommentCountHeight;
    private NoScrollGridView headGridView;
    private TextView headContent;
    private TextView headTime;
    private TextView headType;
    private TextView headFeedBackCount;
    private TextView emptyOrErrorText;
    private LinearLayout headStatusLayout;
    private ImageView emptyOrErrorImage;
    private LinearLayout headCommentLayout;
    private FeedBackCommentAdapter feedBackCommentAdapter;
    private ImageGirdInListAdapter imageGirdAdapter;
    private AddCommentPresenter addCommentPresenter;
    private GetCommentPresenter getCommentPresenter;
    private long statusTime = 0L;

    @Override
    protected void attachView(@Nullable Bundle savedInstanceState) {
        this.setContentView(R.layout.xdja_activity_feed_back_detail_activity);
    }

    @Override
    protected void initView(@Nullable Bundle savedInstanceState) {
        super.initView(savedInstanceState);
        LayoutInflater inflater = LayoutInflater.from((Context)this);
        this.initHeader(inflater);
        this.initCommentView();
        this.initBottom();
        this.initFeedBackDetailDate();
        this.initPresenter();
    }

    private void initHeader(LayoutInflater inflater) {
        this.headLayout = inflater.inflate(R.layout.xdja_feed_back_detail_header, null);
        this.headGridView = (NoScrollGridView)this.headLayout.findViewById(R.id.gv_feed_back_detail);
        this.headContent = (TextView)this.headLayout.findViewById(R.id.tv_feed_back_content);
        this.headTime = (TextView)this.headLayout.findViewById(R.id.tv_feed_back_time);
        this.headType = (TextView)this.headLayout.findViewById(R.id.tv_feed_back_type);
        this.headFeedBackCount = (TextView)this.headLayout.findViewById(R.id.tv_feed_back_detail_comment_count);
        this.headCommentLayout = (LinearLayout)this.headLayout.findViewById(R.id.ll_feed_back_detail_comment);
        this.headStatusLayout = (LinearLayout)this.headLayout.findViewById(R.id.ll_feed_back_status);
        this.emptyOrErrorText = (TextView)this.headLayout.findViewById(R.id.tv_xdja_feed_back_info);
        this.emptyOrErrorImage = (ImageView)this.headLayout.findViewById(R.id.iv_xdja_feed_back_show);
    }

    private void initCommentView() {
        this.listView = (ListView)this.findViewById(R.id.feed_back_detail_xListView);
        this.listView.addHeaderView(this.headLayout);
        this.mySwipeRefreshLayout = (MySwipeRefreshLayout)this.findViewById(R.id.vRefresh);
        this.mySwipeRefreshLayout.setColorSchemeResources(new int[]{R.color.colorPrimary});
        this.mySwipeRefreshLayout.setSize(1);
        this.mySwipeRefreshLayout.setView((Context)this, (View)this.listView);
        this.mySwipeRefreshLayout.setMoreData(false);
        this.mySwipeRefreshLayout.setOnRefreshListener(this);
        this.mySwipeRefreshLayout.setOnLoadListener(this);
    }

    private void initBottom() {
        this.bottomSubmit = (Button)this.findViewById(R.id.bt_feed_back_detail_submit);
        this.bottomComment = (EditText)this.findViewById(R.id.et_feed_back_detail_comment);
        this.bottomSubmit.setOnClickListener((View.OnClickListener)this);
        this.bottomSubmit.setEnabled(false);
        this.bottomComment.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                if (s.toString().trim().length() == 0) {
                    FeedBackDetailActivity.this.bottomSubmit.setEnabled(false);
                } else {
                    FeedBackDetailActivity.this.bottomSubmit.setEnabled(true);
                }
            }
        });
    }

    private void initFeedBackDetailDate() {
        this.feedBackResponeBean = (GetFeedBackListResBean)this.getIntent().getSerializableExtra("feed_back_bean");
        if (this.feedBackResponeBean == null) {
            this.showToast("\u83b7\u53d6\u53cd\u9988\u8be6\u60c5\u5931\u8d25");
            this.finish();
        }
        ArrayList feedbackFiles = this.feedBackResponeBean.getFeedbackFiles();
        this.imageGirdAdapter = new ImageGirdInListAdapter((Activity)this, feedbackFiles);
        this.headGridView.setAdapter((ListAdapter)this.imageGirdAdapter);
        this.headContent.setText((CharSequence)this.feedBackResponeBean.getDescription());
        this.headTime.setText((CharSequence)DateUtil.getTimeStringFromNow((long)this.feedBackResponeBean.getFeedbackTimestamp()));
        this.headType.setText((CharSequence)this.feedBackResponeBean.getFeedbackType());
        this.feedBackCommentAdapter = new FeedBackCommentAdapter(this.feedBackCommentList, this.feedBackResponeBean.getFeedbackUserId(), (Context)this);
        this.listView.setAdapter((ListAdapter)this.feedBackCommentAdapter);
    }

    private void initPresenter() {
        this.getCommentPresenter = new GetCommentPresenter(this);
        this.addCommentPresenter = new AddCommentPresenter(this);
        this.mySwipeRefreshLayout.setFirstEnterLoading(true);
        this.LoadCommentDate(this.statusTime, this.statusTime);
    }

    private void LoadCommentDate(long startTime, long endTime) {
        this.getCommentPresenter.getFeedBackCommentList(this.feedBackResponeBean.getFeedbackId(), startTime, endTime);
    }

    @Override
    protected void onDestroy() {
        this.setResult(-1);
        super.onDestroy();
    }

    @Override
    public void showGetCommentLoading() {
        this.showLoading(this.getResources().getString(R.string.xdja_feed_back_add_comment));
    }

    @Override
    public void hideGetCommentLoading() {
        this.dismissLoading();
    }

    @Override
    public void onGetComment(List<FeedBackCommentBeen> data, int totalCount, boolean isLastPage) {
        this.operatorCommentList(data, totalCount, isLastPage);
    }

    private void operatorCommentList(List<FeedBackCommentBeen> data, int totalCount, boolean isLastPage) {
        this.headStatusLayout.setVisibility(8);
        this.mySwipeRefreshLayout.setRefreshing(false);
        this.mySwipeRefreshLayout.setLoading(false);
        this.headCommentLayout.setVisibility(0);
        this.mySwipeRefreshLayout.setMoreData(!isLastPage);
        if (this.statusTime == 0L) {
            this.headFeedBackCount.setText((CharSequence)(totalCount + " \u56de\u590d"));
            this.feedBackCommentList.clear();
        }
        this.feedBackCommentList.addAll(data);
        this.feedBackCommentAdapter.notifyDataSetChanged();
    }

    public void onRefresh() {
        this.statusTime = 0L;
        this.LoadCommentDate(this.statusTime, this.statusTime);
    }

    @Override
    public void showEmpty() {
        this.mySwipeRefreshLayout.setRefreshing(false);
        this.mySwipeRefreshLayout.setLoading(false);
        if (this.statusTime == 0L) {
            this.headStatusLayout.setVisibility(0);
            this.emptyOrErrorText.setText((CharSequence)this.getResources().getString(R.string.feed_back_no_comment));
            this.emptyOrErrorImage.setImageResource(R.drawable.xdja_feed_back_ic_empty);
        }
    }

    @Override
    public void showError(String msg) {
        super.showError(msg);
        this.mySwipeRefreshLayout.setRefreshing(false);
        this.mySwipeRefreshLayout.setLoading(false);
        if (this.statusTime == 0L && this.feedBackCommentList.size() == 0) {
            this.headStatusLayout.setVisibility(0);
            this.emptyOrErrorText.setText((CharSequence)msg);
            this.emptyOrErrorImage.setImageResource(R.drawable.xdja_feed_back_ic_error);
        }
    }

    @Override
    public void onLoadMore() {
        this.statusTime = this.feedBackCommentList.get(this.feedBackCommentList.size() - 1).getReplyTimestamp();
        this.LoadCommentDate(0L, this.statusTime);
    }

    @Override
    public void onCommentSuccess(List<FeedBackCommentBeen> data, int totalCount, boolean isLastPage) {
        if (data != null) {
            this.statusTime = 0L;
            this.operatorCommentList(data, totalCount, isLastPage);
        }
        Toast.makeText((Context)this, (CharSequence)"\u56de\u590d\u6210\u529f", (int)0).show();
        this.bottomComment.setText((CharSequence)"");
        if (this.listView.getFirstVisiblePosition() != 0) {
            this.setSelection(1, this.measuredCommentCountHeight);
        }
    }

    public void onClick(View v) {
        this.measuredCommentCountHeight = this.headCommentLayout.getMeasuredHeight();
        String content = this.bottomComment.getText().toString().trim();
        if (content.length() > 200) {
            Toast.makeText((Context)this, (int)R.string.xdja_feed_back_max_input_count, (int)0).show();
            return;
        }
        this.addCommentPresenter.addComment(this.feedBackResponeBean.getFeedbackId(), content, FeedBackManager.getInstance().getUserId(), FeedBackManager.getInstance().getUserName());
    }

    private void setSelection(final int position, final int offset) {
        if (this.listView == null) {
            return;
        }
        this.listView.post(new Runnable(){

            @Override
            public void run() {
                FeedBackDetailActivity.this.listView.smoothScrollToPositionFromTop(position, offset);
            }
        });
    }
}

