/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.feedbacksdk.ui;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.FragmentActivity;
import android.support.v4.widget.SwipeRefreshLayout;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import android.widget.Toast;
import com.bumptech.glide.Glide;
import com.xdja.feedbacklibrary.FeedBackManager;
import com.xdja.feedbacklibrary.bean.comment.FeedBackCommentBeen;
import com.xdja.feedbacklibrary.bean.feedback.GetFeedBackListResBean;
import com.xdja.feedbacksdk.R;
import com.xdja.feedbacksdk.adapter.FeedBackCommentAdapterV4;
import com.xdja.feedbacksdk.adapter.ImageGirdInListAdapter;
import com.xdja.feedbacksdk.base.BaseActivity;
import com.xdja.feedbacksdk.model.AppInfoBean;
import com.xdja.feedbacksdk.presenter.AddCommentPresenter;
import com.xdja.feedbacksdk.presenter.GetCommentPresenter;
import com.xdja.feedbacksdk.view.IAddCommentViewV4;
import com.xdja.feedbacksdk.view.IGetCommentView;
import com.xdja.feedbacksdk.widget.MySwipeRefreshLayout;
import com.xdja.feedbacksdk.widget.NoScrollGridView;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Pattern;

public class FeedBackDetailActivityV4
extends BaseActivity
implements IGetCommentView,
SwipeRefreshLayout.OnRefreshListener,
MySwipeRefreshLayout.OnLoadListener,
IAddCommentViewV4,
View.OnClickListener {
    private ListView listView;
    private EditText bottomComment;
    private Button bottomSubmit;
    private GetFeedBackListResBean feedBackResponeBean;
    private MySwipeRefreshLayout mySwipeRefreshLayout;
    private ArrayList<FeedBackCommentBeen> feedBackCommentList = new ArrayList();
    private View headLayout;
    private NoScrollGridView headGridView;
    private TextView headContent;
    private FeedBackCommentAdapterV4 feedBackCommentAdapter;
    private ImageGirdInListAdapter imageGirdAdapter;
    private AddCommentPresenter addCommentPresenter;
    private GetCommentPresenter getCommentPresenter;
    private long statusTime = 0L;
    public static final String EXTRA_FLAG_APP_INFO = "flag_app_info";
    private AppInfoBean appInfoBean;
    private ImageView app_icon;
    private TextView app_name;
    private TextView app_version;
    private boolean isLastPage = false;
    public static final String EXTRA_FLAG_FEEDBACK_ID = "flag_feedback_id";

    @Override
    protected void attachView(@Nullable Bundle savedInstanceState) {
        this.setContentView(R.layout.xdja_activity_feed_back_detail_activity_v4);
    }

    @Override
    protected void initView(@Nullable Bundle savedInstanceState) {
        super.initView(savedInstanceState);
        LayoutInflater inflater = LayoutInflater.from((Context)this);
        this.feedBackResponeBean = (GetFeedBackListResBean)this.getIntent().getExtras().get("feed_back_bean");
        if (this.feedBackResponeBean == null) {
            this.showToast("\u53cd\u9988\u4fe1\u606f\u6807\u8bc6\u672a\u4f20\u5165");
            this.finish();
        }
        this.initAppInfo();
        this.initHeader(inflater);
        this.initCommentView();
        this.initBottom();
        this.initFeedBackDetailDate();
        this.initPresenter();
    }

    private void initAppInfo() {
        this.app_icon = (ImageView)this.findViewById(R.id.app_icon);
        this.app_name = (TextView)this.findViewById(R.id.app_name);
        this.app_version = (TextView)this.findViewById(R.id.app_version);
        Glide.with((FragmentActivity)this).load(this.feedBackResponeBean.getAppLogoFilePath()).placeholder(R.drawable.app_load_img_default).into(this.app_icon);
        this.app_name.setText((CharSequence)this.feedBackResponeBean.getAppName());
        this.app_version.setText((CharSequence)String.format("\u7248\u672c:%s", this.feedBackResponeBean.getAppVersionName()));
    }

    private void initHeader(LayoutInflater inflater) {
        String currentUser = FeedBackManager.getInstance().getUserId();
        if (currentUser.equals(this.feedBackResponeBean.getFeedbackUserId())) {
            this.headLayout = inflater.inflate(R.layout.xdja_feed_back_detail_header_v4, null);
            this.headGridView = (NoScrollGridView)this.headLayout.findViewById(R.id.gv_feed_back_detail);
            this.headContent = (TextView)this.headLayout.findViewById(R.id.tv_feed_back_content);
        } else {
            this.headLayout = inflater.inflate(R.layout.xdja_feed_back_detail_header_left_v4, null);
            this.headGridView = (NoScrollGridView)this.headLayout.findViewById(R.id.gv_feed_back_detail);
            this.headContent = (TextView)this.headLayout.findViewById(R.id.tv_feed_back_content);
        }
    }

    private void initCommentView() {
        this.listView = (ListView)this.findViewById(R.id.feed_back_detail_xListView);
        this.listView.addHeaderView(this.headLayout);
        this.mySwipeRefreshLayout = (MySwipeRefreshLayout)this.findViewById(R.id.vRefresh);
        this.mySwipeRefreshLayout.setColorSchemeResources(new int[]{R.color.colorPrimary});
        this.mySwipeRefreshLayout.setSize(1);
        this.mySwipeRefreshLayout.setView((Context)this, (View)this.listView);
        this.mySwipeRefreshLayout.setMoreData(false);
        this.mySwipeRefreshLayout.setOnRefreshListener(this);
        this.mySwipeRefreshLayout.setOnLoadListener(this);
    }

    private void initBottom() {
        this.bottomSubmit = (Button)this.findViewById(R.id.bt_feed_back_detail_submit);
        this.bottomComment = (EditText)this.findViewById(R.id.et_feed_back_detail_comment);
        this.bottomSubmit.setOnClickListener((View.OnClickListener)this);
        this.bottomSubmit.setEnabled(false);
        this.bottomComment.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                if (s.toString().trim().length() == 0) {
                    FeedBackDetailActivityV4.this.bottomSubmit.setEnabled(false);
                } else if (FeedBackDetailActivityV4.this.isInvalid(s.toString())) {
                    FeedBackDetailActivityV4.this.bottomSubmit.setEnabled(true);
                }
            }
        });
    }

    private void initFeedBackDetailDate() {
        ArrayList feedbackFiles = this.feedBackResponeBean.getFeedbackFiles();
        this.imageGirdAdapter = new ImageGirdInListAdapter((Activity)this, feedbackFiles);
        this.headGridView.setAdapter((ListAdapter)this.imageGirdAdapter);
        this.headContent.setText((CharSequence)(this.feedBackResponeBean.getOptionsDesc() + ";" + (TextUtils.isEmpty((CharSequence)this.feedBackResponeBean.getDescription()) ? "" : this.feedBackResponeBean.getDescription())));
        this.feedBackCommentAdapter = new FeedBackCommentAdapterV4(this.feedBackCommentList, this.feedBackResponeBean.getFeedbackUserId(), (Context)this);
        this.listView.setAdapter((ListAdapter)this.feedBackCommentAdapter);
    }

    private void initPresenter() {
        this.getCommentPresenter = new GetCommentPresenter(this);
        this.addCommentPresenter = new AddCommentPresenter(this);
        this.mySwipeRefreshLayout.setFirstEnterLoading(true);
        this.LoadCommentDate(this.statusTime, this.statusTime);
    }

    private void LoadCommentDate(long startTime, long endTime) {
        this.getCommentPresenter.getFeedBackCommentList(this.feedBackResponeBean.getFeedbackId(), startTime, endTime);
    }

    @Override
    protected void onDestroy() {
        this.setResult(-1);
        super.onDestroy();
    }

    @Override
    public void showGetCommentLoading() {
        this.showLoading("\u83b7\u53d6\u53cd\u9988\u8be6\u60c5\u4e2d");
    }

    @Override
    public void hideGetCommentLoading() {
        this.dismissLoading();
    }

    @Override
    public void onGetComment(List<FeedBackCommentBeen> data, int totalCount, boolean isLastPage) {
        this.operatorCommentList(data, totalCount, isLastPage);
    }

    private void operatorCommentList(List<FeedBackCommentBeen> data, int totalCount, boolean isLastPage) {
        this.mySwipeRefreshLayout.setRefreshing(false);
        this.mySwipeRefreshLayout.setLoading(false);
        this.isLastPage = isLastPage;
        if (this.statusTime == 0L) {
            this.feedBackCommentList.clear();
        }
        this.feedBackCommentList.addAll(data);
        Collections.sort(this.feedBackCommentList, new Comparator<FeedBackCommentBeen>(){

            @Override
            public int compare(FeedBackCommentBeen lhs, FeedBackCommentBeen rhs) {
                if (lhs.getReplyTimestamp() < rhs.getReplyTimestamp()) {
                    return -1;
                }
                return 1;
            }
        });
        this.feedBackCommentAdapter.notifyDataSetChanged();
    }

    public void onRefresh() {
        if (this.isLastPage) {
            this.showToast("\u65e0\u66f4\u591a\u6d88\u606f");
            this.mySwipeRefreshLayout.setRefreshing(false);
            this.mySwipeRefreshLayout.setLoading(false);
        } else {
            this.loadMore();
        }
    }

    @Override
    public void showEmpty() {
        this.mySwipeRefreshLayout.setRefreshing(false);
        this.mySwipeRefreshLayout.setLoading(false);
        if (this.statusTime == 0L) {
            // empty if block
        }
    }

    @Override
    public void showError(String msg) {
        super.showError(msg);
        this.mySwipeRefreshLayout.setRefreshing(false);
        this.mySwipeRefreshLayout.setLoading(false);
        if (this.statusTime != 0L || this.feedBackCommentList.size() == 0) {
            // empty if block
        }
    }

    private void loadMore() {
        this.statusTime = this.feedBackCommentList != null && !this.feedBackCommentList.isEmpty() ? this.feedBackCommentList.get(0).getReplyTimestamp() : System.currentTimeMillis();
        this.LoadCommentDate(0L, this.statusTime);
    }

    @Override
    public void onLoadMore() {
    }

    private boolean isInvalid(String comment) {
        if (TextUtils.isEmpty((CharSequence)comment) || comment.length() < 2) {
            return false;
        }
        String pattern = "[ |\\n]+";
        return !Pattern.matches(pattern, comment);
    }

    @Override
    public void onCommentSuccess(List<FeedBackCommentBeen> data, int totalCount, boolean isLastPage) {
        if (data != null) {
            this.statusTime = 0L;
            this.operatorCommentList(data, totalCount, isLastPage);
        }
        Toast.makeText((Context)this, (CharSequence)"\u56de\u590d\u6210\u529f", (int)0).show();
        this.bottomComment.setText((CharSequence)"");
        if (this.listView.getFirstVisiblePosition() != 0) {
            // empty if block
        }
    }

    public void onClick(View v) {
        String content = this.bottomComment.getText().toString().trim();
        this.bottomComment.setText((CharSequence)"");
        if (content.length() > 200) {
            Toast.makeText((Context)this, (int)R.string.xdja_feed_back_max_input_count, (int)0).show();
            return;
        }
        this.addCommentPresenter.addComment(this.feedBackResponeBean.getFeedbackId(), content, FeedBackManager.getInstance().getUserId(), FeedBackManager.getInstance().getUserName());
    }

    private void setSelection(final int position, final int offset) {
        if (this.listView == null) {
            return;
        }
        this.listView.post(new Runnable(){

            @Override
            public void run() {
                FeedBackDetailActivityV4.this.listView.smoothScrollToPositionFromTop(position, offset);
            }
        });
    }

    @Override
    public void onCommentting(FeedBackCommentBeen bean) {
    }

    @Override
    public void onCommentDetail(GetFeedBackListResBean backListResBean) {
        if (TextUtils.isEmpty((CharSequence)backListResBean.getAppId())) {
            this.showToast("\u53cd\u9988\u8be6\u60c5\u4e0d\u5b58\u5728");
            this.finish();
        }
        this.feedBackResponeBean = backListResBean;
        ArrayList feedbackFiles = this.feedBackResponeBean.getFeedbackFiles();
        this.imageGirdAdapter = new ImageGirdInListAdapter((Activity)this, feedbackFiles);
        this.headGridView.setAdapter((ListAdapter)this.imageGirdAdapter);
        this.headContent.setText((CharSequence)this.feedBackResponeBean.getDescription());
        this.feedBackCommentAdapter = new FeedBackCommentAdapterV4(this.feedBackCommentList, this.feedBackResponeBean.getFeedbackUserId(), (Context)this);
        this.listView.setAdapter((ListAdapter)this.feedBackCommentAdapter);
        this.statusTime = System.currentTimeMillis();
        this.LoadCommentDate(0L, this.statusTime);
    }
}

