/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.feedbacksdk.ui;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.widget.SwipeRefreshLayout;
import android.text.TextUtils;
import android.view.View;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.xdja.feedbacklibrary.FeedBackManager;
import com.xdja.feedbacklibrary.bean.feedback.GetFeedBackListResBean;
import com.xdja.feedbacklibrary.crashcollect.beancompile.CollectInfoCompile;
import com.xdja.feedbacklibrary.http.bean.ResponseBean;
import com.xdja.feedbacksdk.R;
import com.xdja.feedbacksdk.adapter.FeedbackAdapter;
import com.xdja.feedbacksdk.base.BaseActivity;
import com.xdja.feedbacksdk.presenter.FeedbackPresenter;
import com.xdja.feedbacksdk.ui.PublishFeedBackActivityPermissionsDispatcher;
import com.xdja.feedbacksdk.ui.StartPublishFeedBackActivity;
import com.xdja.feedbacksdk.view.IFeedbackView;
import com.xdja.feedbacksdk.widget.MySwipeRefreshLayout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import permissions.dispatcher.NeedsPermission;
import permissions.dispatcher.OnNeverAskAgain;
import permissions.dispatcher.OnPermissionDenied;
import permissions.dispatcher.RuntimePermissions;

@RuntimePermissions
public class PublishFeedBackActivity
extends BaseActivity
implements IFeedbackView<ResponseBean<List<GetFeedBackListResBean>>>,
View.OnClickListener {
    public static final String FEED_BACK_BEAN = "feed_back_bean";
    public static final String PACKAGE_NAME = "PACKAGE_NAME";
    public static final int FEEDBACK_DETAIL_REQUEST_CODE = 1;
    public static final int COMMIT_FEEDBACK_REQUEST_CODE = 2;
    private MySwipeRefreshLayout swipeRefreshLayout;
    private ListView listView;
    private FeedbackAdapter feedbackAdapter;
    private View errorLy;
    private List<GetFeedBackListResBean> data;
    private FeedbackPresenter feedbackPresenter;
    private RelativeLayout feedBackLy;
    private ImageView backBtn;
    private TextView commitTv;
    private Bundle extras;
    private String packageName;

    @Override
    protected void attachView(@Nullable Bundle savedInstanceState) {
        this.setContentView(R.layout.xdja_activity_feed_back);
        PublishFeedBackActivityPermissionsDispatcher.gaintMyPermissionsWithPermissionCheck(this);
    }

    @NeedsPermission(value={"android.permission.READ_PHONE_STATE"})
    protected void gaintMyPermissions() {
        CollectInfoCompile.getInstance().init((Context)this);
    }

    @OnPermissionDenied(value={"android.permission.READ_PHONE_STATE"})
    void onMyPermissionDenied() {
        this.showWaringDialog();
    }

    @OnNeverAskAgain(value={"android.permission.READ_PHONE_STATE"})
    void onCameraNeverAskAgain() {
        this.showWaringDialog();
    }

    private void showWaringDialog() {
        AlertDialog dialog = new AlertDialog.Builder((Context)this).setTitle((CharSequence)"\u8b66\u544a\uff01").setMessage((CharSequence)"\u8bf7\u524d\u5f80\u8bbe\u7f6e->\u5e94\u7528->\u6743\u9650\u4e2d\u6253\u5f00\u76f8\u5173\u6743\u9650\uff0c\u5426\u5219\u529f\u80fd\u65e0\u6cd5\u6b63\u5e38\u8fd0\u884c\uff01").setPositiveButton((CharSequence)"\u786e\u5b9a", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS", Uri.parse((String)("package:" + PublishFeedBackActivity.this.getPackageName())));
                PublishFeedBackActivity.this.startActivity(intent);
                PublishFeedBackActivity.this.finish();
            }
        }).show();
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        PublishFeedBackActivityPermissionsDispatcher.onRequestPermissionsResult(this, requestCode, grantResults);
    }

    @Override
    protected void initView(@Nullable Bundle savedInstanceState) {
        super.initView(savedInstanceState);
        this.extras = this.getIntent().getExtras();
        this.packageName = this.getIntent().getStringExtra(PACKAGE_NAME);
        this.feedBackLy = (RelativeLayout)this.findViewById(R.id.need_feed_back_ly);
        this.feedBackLy.setOnClickListener((View.OnClickListener)this);
        this.listView = (ListView)this.findViewById(R.id.lv_content);
        this.errorLy = this.findViewById(R.id.public_error_ly);
        this.commitTv = (TextView)this.findViewById(R.id.commit_title_tv);
        this.swipeRefreshLayout = (MySwipeRefreshLayout)this.findViewById(R.id.sl_feedback);
        this.data = new ArrayList<GetFeedBackListResBean>();
        this.feedbackAdapter = new FeedbackAdapter((Activity)this, this.data);
        this.listView.setAdapter((ListAdapter)this.feedbackAdapter);
        this.swipeRefreshLayout.setView((Context)this, (View)this.listView);
        this.swipeRefreshLayout.setColorSchemeResources(new int[]{R.color.colorPrimary});
        this.feedbackPresenter = new FeedbackPresenter(this);
        this.swipeRefreshLayout.setFirstEnterLoading(true);
        this.feedbackPresenter.pullDown2Refrush(FeedBackManager.getInstance().getUserId(), this.getSendPackageName(), -1L);
        this.swipeRefreshLayout.setOnRefreshListener(new SwipeRefreshLayout.OnRefreshListener(){

            public void onRefresh() {
                PublishFeedBackActivity.this.feedbackPresenter.pullDown2Refrush(FeedBackManager.getInstance().getUserId(), PublishFeedBackActivity.this.getSendPackageName(), -1L);
            }
        });
        this.swipeRefreshLayout.setOnLoadListener(new MySwipeRefreshLayout.OnLoadListener(){

            @Override
            public void onLoadMore() {
                long endTime = -1L;
                if (PublishFeedBackActivity.this.data != null && !PublishFeedBackActivity.this.data.isEmpty()) {
                    endTime = ((GetFeedBackListResBean)PublishFeedBackActivity.this.data.get(PublishFeedBackActivity.this.data.size() - 1)).getFeedbackTimestamp();
                }
                PublishFeedBackActivity.this.feedbackPresenter.loadMore(FeedBackManager.getInstance().getUserId(), PublishFeedBackActivity.this.getSendPackageName(), endTime);
            }
        });
        this.errorLy.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PublishFeedBackActivity.this.errorLy.setVisibility(8);
                PublishFeedBackActivity.this.feedbackPresenter.pullDown2Refrush(FeedBackManager.getInstance().getUserId(), PublishFeedBackActivity.this.getSendPackageName(), -1L);
            }
        });
    }

    public void reload() {
        this.swipeRefreshLayout.setFirstEnterLoading(true);
        this.feedbackPresenter.pullDown2Refrush(FeedBackManager.getInstance().getUserId(), this.getSendPackageName(), -1L);
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == 2 || requestCode == 1) {
            this.reload();
        }
    }

    @Override
    public void showEmpty() {
        this.swipeRefreshLayout.setLoading(false);
        this.swipeRefreshLayout.setRefreshing(false);
        if (this.data == null || this.data.isEmpty()) {
            this.errorLy.setVisibility(0);
            this.commitTv.setVisibility(8);
            this.swipeRefreshLayout.setVisibility(8);
        }
    }

    @Override
    public void success(ResponseBean<List<GetFeedBackListResBean>> responseBean, int operate) {
        this.commitTv.setVisibility(0);
        this.swipeRefreshLayout.setVisibility(0);
        if (responseBean.isLastPage()) {
            this.swipeRefreshLayout.setMoreData(false);
        } else {
            this.swipeRefreshLayout.setMoreData(true);
        }
        if (operate == 1) {
            this.data.clear();
            this.data.addAll(0, (Collection)responseBean.getData());
            this.swipeRefreshLayout.setRefreshing(false);
        } else {
            this.data.addAll((Collection)responseBean.getData());
            this.swipeRefreshLayout.setLoading(false);
        }
        this.feedbackAdapter.notifyDataSetChanged();
    }

    @Override
    public void showError(String msg) {
        this.swipeRefreshLayout.setLoading(false);
        this.swipeRefreshLayout.setRefreshing(false);
        if (this.data == null || this.data.isEmpty()) {
            this.errorLy.setVisibility(0);
            this.commitTv.setVisibility(8);
            this.swipeRefreshLayout.setVisibility(8);
        } else {
            if (TextUtils.isEmpty((CharSequence)msg)) {
                msg = "\u83b7\u53d6\u53cd\u9988\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458";
            }
            this.showToast(msg);
        }
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (R.id.need_feed_back_ly == id2) {
            Intent intent = new Intent((Context)this, StartPublishFeedBackActivity.class);
            intent.putExtra(PACKAGE_NAME, this.packageName);
            if (this.extras != null) {
                intent.putExtras(this.extras);
            }
            this.startActivityForResult(intent, 2);
        }
    }

    String getSendPackageName() {
        if (TextUtils.isEmpty((CharSequence)this.packageName)) {
            return this.getPackageName();
        }
        return this.packageName;
    }
}

