/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.feedbacksdk.ui;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Environment;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.FragmentActivity;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.text.format.DateFormat;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.EditText;
import android.widget.GridView;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.TextView;
import com.bumptech.glide.Glide;
import com.flyou.pictureselecter.PictureSelecter;
import com.xdja.feedbacklibrary.FeedBackManager;
import com.xdja.feedbacklibrary.bean.feedback.FeedbackTypeResponeBean;
import com.xdja.feedbacklibrary.constants.FBConstants;
import com.xdja.feedbacklibrary.http.bean.ResponseBean;
import com.xdja.feedbacklibrary.util.NetUtil;
import com.xdja.feedbacklibrary.util.SystemUtil;
import com.xdja.feedbacksdk.R;
import com.xdja.feedbacksdk.adapter.ImageGirdAdapter;
import com.xdja.feedbacksdk.base.BaseActivity;
import com.xdja.feedbacksdk.model.AppInfoBean;
import com.xdja.feedbacksdk.presenter.PublishFeedBackPresenter;
import com.xdja.feedbacksdk.ui.StartPublishFeedBackActivityPermissionsDispatcher;
import com.xdja.feedbacksdk.utils.FileProviderUtils;
import com.xdja.feedbacksdk.view.IPublishFBView;
import com.xdja.feedbacksdk.widget.MultiLinearLayout;
import com.xdja.feedbacksdk.widget.NoScrollGridView;
import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import permissions.dispatcher.NeedsPermission;
import permissions.dispatcher.OnNeverAskAgain;
import permissions.dispatcher.OnPermissionDenied;
import permissions.dispatcher.RuntimePermissions;

@RuntimePermissions
public class StartPublishFeedBackActivity
extends BaseActivity
implements View.OnClickListener,
ImageGirdAdapter.OnDelListener,
ImageGirdAdapter.OnAddImageListener,
IPublishFBView<ResponseBean<List<FeedbackTypeResponeBean>>> {
    public static final int REQUST_CODE_PICTURE = 100;
    public static final int REQUEST_CODE_CAMERA = 101;
    public static final String RESULT_KEY = "result_key";
    private GridView gridView;
    private ImageGirdAdapter adapter;
    private ArrayList<String> imgs = new ArrayList();
    private EditText contentEdit;
    private TextView countTv;
    String camera_pic_path = "";
    String fileName = "";
    private ImageView appIconImg;
    private TextView appNameTv;
    private TextView appNameVersion;
    private LinearLayout llAppHeader;
    private PublishFeedBackPresenter presenter;
    private AppInfoBean appInfoBean;
    private Button addImgBtn;
    private MultiLinearLayout feedBackTypeLy;
    private StringBuffer stringBuffer;

    @Override
    protected void attachView(@Nullable Bundle savedInstanceState) {
        this.setContentView(R.layout.xdja_activity_publish_feed_back);
        StartPublishFeedBackActivityPermissionsDispatcher.gaintMyPermissionsWithPermissionCheck(this);
    }

    @NeedsPermission(value={"android.permission.CAMERA", "android.permission.READ_PHONE_STATE", "android.permission.WRITE_EXTERNAL_STORAGE"})
    protected void gaintMyPermissions() {
    }

    @OnPermissionDenied(value={"android.permission.CAMERA", "android.permission.READ_PHONE_STATE", "android.permission.WRITE_EXTERNAL_STORAGE"})
    void onMyPermissionDenied() {
        this.showWaringDialog();
    }

    @OnNeverAskAgain(value={"android.permission.CAMERA", "android.permission.READ_PHONE_STATE", "android.permission.WRITE_EXTERNAL_STORAGE"})
    void onCameraNeverAskAgain() {
        this.showWaringDialog();
    }

    private void showWaringDialog() {
        AlertDialog dialog = new AlertDialog.Builder((Context)this).setTitle((CharSequence)"\u8b66\u544a\uff01").setMessage((CharSequence)"\u8bf7\u524d\u5f80\u8bbe\u7f6e->\u5e94\u7528->\u6743\u9650\u4e2d\u6253\u5f00\u76f8\u5173\u6743\u9650\uff0c\u5426\u5219\u529f\u80fd\u65e0\u6cd5\u6b63\u5e38\u8fd0\u884c\uff01").setPositiveButton((CharSequence)"\u786e\u5b9a", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS", Uri.parse((String)("package:" + StartPublishFeedBackActivity.this.getPackageName())));
                StartPublishFeedBackActivity.this.startActivity(intent);
                StartPublishFeedBackActivity.this.finish();
            }
        }).show();
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        StartPublishFeedBackActivityPermissionsDispatcher.onRequestPermissionsResult(this, requestCode, grantResults);
    }

    @Override
    protected void initView(@Nullable Bundle savedInstanceState) {
        super.initView(savedInstanceState);
        this.stringBuffer = new StringBuffer();
        Bundle extras = this.getIntent().getExtras();
        this.llAppHeader = (LinearLayout)this.findViewById(R.id.ll_app_header);
        if (extras != null) {
            this.appInfoBean = (AppInfoBean)extras.getSerializable("appInfo");
        }
        if (this.appInfoBean == null) {
            this.llAppHeader.setVisibility(8);
            String packageName = this.getIntent().getStringExtra("PACKAGE_NAME");
            if (TextUtils.isEmpty((CharSequence)packageName)) {
                packageName = this.getPackageName();
            }
            this.appInfoBean = new AppInfoBean();
            this.appInfoBean.setAppPackage(packageName);
            this.appInfoBean.setPhoneNumber("");
        }
        this.feedBackTypeLy = (MultiLinearLayout)this.findViewById(R.id.feed_back_type_ly);
        this.llAppHeader = (LinearLayout)this.findViewById(R.id.ll_app_header);
        this.appNameTv = (TextView)this.findViewById(R.id.app_name);
        if (this.appInfoBean != null) {
            this.appNameTv.setText((CharSequence)this.appInfoBean.getAppName());
        }
        this.appNameVersion = (TextView)this.findViewById(R.id.app_version);
        if (this.appInfoBean != null) {
            String appPackage = this.appInfoBean.getAppPackage();
            String appVersionName = SystemUtil.getAppVersionName((Context)this.getApplicationContext(), (String)appPackage);
            if (TextUtils.isEmpty((CharSequence)appVersionName)) {
                appVersionName = this.appInfoBean.getAppVersion();
            }
            this.appNameVersion.setText((CharSequence)("\u7248\u672c:" + appVersionName));
        }
        this.appIconImg = (ImageView)this.findViewById(R.id.app_icon);
        if (this.appInfoBean != null) {
            Glide.with((FragmentActivity)this).load(this.appInfoBean.getAppLogoFilePath()).placeholder(R.drawable.app_load_img_default).into(this.appIconImg);
        }
        this.presenter = new PublishFeedBackPresenter(this);
        this.loadFeedBackType();
        this.addImgBtn = (Button)this.findViewById(R.id.addImgBtn);
        this.addImgBtn.setOnClickListener((View.OnClickListener)this);
        this.contentEdit = (EditText)this.findViewById(R.id.content);
        this.countTv = (TextView)this.findViewById(R.id.countTv);
        this.gridView = (NoScrollGridView)this.findViewById(R.id.gridView);
        this.adapter = new ImageGirdAdapter((Activity)this, this.imgs);
        this.adapter.showDelBtn(true);
        this.adapter.setOnDelListener(this);
        this.adapter.setOnAddImageListener(this);
        this.gridView.setAdapter((ListAdapter)this.adapter);
        this.contentEdit.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                String content = StartPublishFeedBackActivity.this.contentEdit.getText().toString();
                if (content.length() > 200) {
                    content = content.substring(0, 200);
                    StartPublishFeedBackActivity.this.contentEdit.setText((CharSequence)content);
                    StartPublishFeedBackActivity.this.contentEdit.setSelection(200);
                    StartPublishFeedBackActivity.this.showToast("\u6700\u591a\u8f93\u5165200\u5b57\u54e6\uff0c\u8bf7\u7b5b\u9009\u4e3b\u8981\u5185\u5bb9\u7f16\u8f91\u63d0\u4ea4\u3002");
                }
                StartPublishFeedBackActivity.this.countTv.setText((CharSequence)(content.length() + "/200"));
            }
        });
    }

    private void loadFeedBackType() {
        this.presenter.loadFeedBackType();
    }

    public void onClick(View v) {
        int i = v.getId();
        if (i == R.id.addImgBtn) {
            this.showBottomPopupWin();
        }
    }

    private void commitFeedback() {
        if (!NetUtil.isNetworkAvailable((Context)this)) {
            this.showToast("\u8bf7\u68c0\u67e5\u7f51\u7edc\u8fde\u63a5");
            return;
        }
        FBConstants.FeedBackType type = FBConstants.FeedBackType.PROBLEM;
        String content = this.contentEdit.getText().toString();
        String options = this.stringBuffer.toString();
        if (TextUtils.isEmpty((CharSequence)options)) {
            this.showToast("\u53cd\u9988\u539f\u56e0\u4e0d\u80fd\u4e3a\u7a7a");
            return;
        }
        ArrayList<String> tmpList = this.imgs;
        if (tmpList.size() > 0 && tmpList.get(tmpList.size() - 1).equals(ImageGirdAdapter.ADD_IMAGE_TAG)) {
            tmpList.remove(tmpList.size() - 1);
        }
        Object[] split = options.split("");
        String optionStr = StartPublishFeedBackActivity.join(split, ',');
        if (SystemUtil.hasInstalled((Context)this, (String)this.appInfoBean.getAppPackage())) {
            this.presenter.commitFeedBack(FeedBackManager.getInstance().getUserId(), FeedBackManager.getInstance().getUserName(), content, type.getIndex(), this.appInfoBean.getPhoneNumber(), tmpList, this.appInfoBean.getAppPackage(), optionStr);
        } else {
            this.presenter.commitFeedBack(FeedBackManager.getInstance().getUserId(), FeedBackManager.getInstance().getUserName(), content, type.getIndex(), this.appInfoBean.getPhoneNumber(), tmpList, this.appInfoBean.getAppPackage(), this.appInfoBean.getAppName(), this.appInfoBean.getAppVersion(), optionStr);
        }
    }

    public static String join(Object[] array, char separator) {
        if (array == null) {
            return null;
        }
        int arraySize = array.length;
        int bufSize = arraySize == 0 ? 0 : ((array[0] == null ? 16 : array[0].toString().length()) + 1) * arraySize;
        StringBuffer buf = new StringBuffer(bufSize);
        for (int i = 0; i < arraySize; ++i) {
            if (i > 1 && i < arraySize) {
                buf.append(separator);
            }
            if (array[i] == null) continue;
            buf.append(array[i]);
        }
        return buf.toString();
    }

    private void reset() {
        this.contentEdit.setText((CharSequence)"");
        this.imgs.clear();
        this.adapter.notifyDataSetChanged();
        this.addImgBtn.setVisibility(this.imgs.size() > 0 ? 8 : 0);
        this.gridView.setVisibility(this.imgs.size() > 0 ? 0 : 8);
        if (this.stringBuffer != null) {
            this.stringBuffer.delete(0, this.stringBuffer.length());
        }
        if (this.feedBackTypeLy != null) {
            this.feedBackTypeLy.invalidate();
        }
    }

    private void addImage() {
        PictureSelecter.getPicture((Activity)this, 100, this.imgs, RESULT_KEY);
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (resultCode == -1) {
            switch (requestCode) {
                case 100: {
                    ArrayList files = data.getStringArrayListExtra(RESULT_KEY);
                    if (null != files && files.size() > 0) {
                        this.imgs = files;
                        if (this.imgs.size() < 3) {
                            this.imgs.add(ImageGirdAdapter.ADD_IMAGE_TAG);
                        }
                        this.adapter.setData(this.imgs);
                        this.adapter.notifyDataSetChanged();
                    }
                    this.addImgBtn.setVisibility(this.imgs.size() > 0 ? 8 : 0);
                    this.gridView.setVisibility(this.imgs.size() > 0 ? 0 : 8);
                    break;
                }
                case 101: {
                    if (this.imgs.size() > 0) {
                        this.imgs.remove(this.imgs.size() - 1);
                    }
                    this.sendBroadcast(new Intent("android.intent.action.MEDIA_SCANNER_SCAN_FILE", Uri.parse((String)("file://" + this.camera_pic_path))));
                    this.imgs.add(this.camera_pic_path);
                    if (this.imgs.size() < 3) {
                        this.imgs.add(ImageGirdAdapter.ADD_IMAGE_TAG);
                    }
                    this.adapter.notifyDataSetChanged();
                    this.addImgBtn.setVisibility(this.imgs.size() > 0 ? 8 : 0);
                    this.gridView.setVisibility(this.imgs.size() > 0 ? 0 : 8);
                }
            }
        }
    }

    @Override
    public void OnDel(String filePath, int pos) {
        if (null != this.imgs) {
            this.imgs.remove(pos);
            if (this.imgs.size() <= 8 && this.imgs.size() > 0 && !this.imgs.get(this.imgs.size() - 1).equals(ImageGirdAdapter.ADD_IMAGE_TAG)) {
                this.imgs.add(ImageGirdAdapter.ADD_IMAGE_TAG);
            }
            if (this.imgs.size() == 1) {
                this.imgs.clear();
            }
            this.adapter.notifyDataSetChanged();
            this.addImgBtn.setVisibility(this.imgs.size() > 0 ? 8 : 0);
            this.gridView.setVisibility(this.imgs.size() > 0 ? 0 : 8);
        }
    }

    @Override
    public void onAddImage() {
        this.showBottomPopupWin();
    }

    public void showBottomPopupWin() {
        final AlertDialog dlg = new AlertDialog.Builder((Context)this).create();
        dlg.show();
        Window window = dlg.getWindow();
        WindowManager.LayoutParams lp = window.getAttributes();
        lp.width = this.getResources().getDimensionPixelOffset(R.dimen.picture_selector_progress_dialog_width);
        window.setAttributes(lp);
        window.setContentView(R.layout.xdja_feed_back_alertdialog);
        TextView takeVideo = (TextView)window.findViewById(R.id.tv_takephoto);
        takeVideo.setVisibility(0);
        takeVideo.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                dlg.dismiss();
                StartPublishFeedBackActivity.this.pickPhotoFromCamera();
            }
        });
        TextView takePhoto = (TextView)window.findViewById(R.id.tv_localphoto);
        takePhoto.setVisibility(0);
        takePhoto.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                dlg.dismiss();
                StartPublishFeedBackActivity.this.addImage();
            }
        });
    }

    private void pickPhotoFromCamera() {
        String sdStatus = Environment.getExternalStorageState();
        if (!sdStatus.equals("mounted")) {
            return;
        }
        Intent intent = new Intent("android.media.action.IMAGE_CAPTURE");
        this.fileName = DateFormat.format((CharSequence)"yyyyMMddhhmmss", (Calendar)Calendar.getInstance(Locale.CHINA)) + ".jpg";
        File file = new File(FBConstants.PICTURE_FOLDER);
        if (!file.exists()) {
            file.mkdirs();
        }
        this.camera_pic_path = FBConstants.PICTURE_FOLDER + this.fileName;
        File mCurrentPhotoFile = new File(this.camera_pic_path);
        intent.putExtra("output", (Parcelable)FileProviderUtils.getUriForFile((Context)this, mCurrentPhotoFile));
        this.startActivityForResult(intent, 101);
    }

    @Override
    public void showError(String msg) {
        if (TextUtils.isEmpty((CharSequence)msg)) {
            msg = "\u63d0\u4ea4\u53cd\u9988\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458";
        }
        this.showToast(msg);
    }

    protected void onPause() {
        super.onPause();
    }

    @Override
    public void success(ResponseBean<List<FeedbackTypeResponeBean>> listResponseBean, int operation) {
        List data;
        this.dismissLoading();
        if (operation == PublishFeedBackPresenter.COMMIT_FEEDBACK) {
            this.showToast("\u60a8\u7684\u53cd\u9988\u5df2\u63d0\u4ea4\u6210\u529f\uff0c\u6211\u4eec\u4f1a\u5c3d\u5feb\u8ddf\u8e2a\u53cd\u9988\u60a8\u7684\u95ee\u9898\u3002");
            this.finish();
        } else if (operation == PublishFeedBackPresenter.LOAD_FEEDBACK_TYPE && (data = (List)listResponseBean.getData()) != null && data.size() > 0) {
            for (int i = 0; i < data.size(); ++i) {
                View convertView = LayoutInflater.from((Context)this).inflate(R.layout.feed_back_type_item, null);
                CheckBox lableBtn = (CheckBox)convertView.findViewById(R.id.feed_back_type_item_btn);
                this.feedBackTypeLy.setPadding(16, 0, 16, 0);
                this.feedBackTypeLy.setmLeft(16);
                this.feedBackTypeLy.setmRight(16);
                this.feedBackTypeLy.setmTop(10);
                this.feedBackTypeLy.setmBottom(10);
                this.feedBackTypeLy.setMaginLeftAndRight(20);
                this.feedBackTypeLy.setMaginTopAndBottom(20);
                FeedbackTypeResponeBean feedbackTypeResponeBean = (FeedbackTypeResponeBean)data.get(i);
                this.feedBackTypeLy.addNameBtn((Context)this, feedbackTypeResponeBean.getName(), lableBtn, feedbackTypeResponeBean.getCode());
                this.feedBackTypeLy.setNameButtonListener(new MultiLinearLayout.OnNameButtonListener(){

                    @Override
                    public void onNameBtnClick(View v, String value) {
                        int indexOf = StartPublishFeedBackActivity.this.stringBuffer.indexOf(value);
                        if (indexOf > -1) {
                            StartPublishFeedBackActivity.this.stringBuffer.deleteCharAt(indexOf);
                        } else {
                            StartPublishFeedBackActivity.this.stringBuffer.append(value);
                        }
                    }
                });
            }
        }
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        this.getMenuInflater().inflate(R.menu.publish_menu, menu2);
        return true;
    }

    @Override
    public boolean onMenuItemClick(MenuItem menuItem) {
        int i = menuItem.getItemId();
        if (i == R.id.action_submit) {
            this.commitFeedback();
        }
        return false;
    }
}

