/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.feedbacksdk.ui.fragment;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.ProgressBar;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.request.animation.GlideAnimation;
import com.bumptech.glide.request.target.SimpleTarget;
import com.bumptech.glide.request.target.Target;
import com.flyou.pictureselecter.util.FileUtils;
import com.xdja.feedbacksdk.R;
import com.xdja.feedbacksdk.widget.photoview.PhotoViewAttacher;

public class ImagePreviewFragment
extends Fragment {
    public static final String PATH = "path";

    public static ImagePreviewFragment getInstance(String path) {
        ImagePreviewFragment fragment = new ImagePreviewFragment();
        Bundle bundle = new Bundle();
        bundle.putString(PATH, path);
        fragment.setArguments(bundle);
        return fragment;
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View contentView = inflater.inflate(R.layout.xdja_picture_selector_choose_big_pic_item, container, false);
        final ImageView imageView = (ImageView)contentView.findViewById(R.id.img_pic);
        final ProgressBar progressBar = (ProgressBar)contentView.findViewById(R.id.pb_loading);
        final PhotoViewAttacher mAttacher = new PhotoViewAttacher(imageView);
        String fielEtx = FileUtils.getFileExtension(this.getArguments().getString(PATH)).toLowerCase();
        boolean isGif = fielEtx.equals("gif");
        if (isGif) {
            Glide.with((Context)container.getContext()).load(this.getArguments().getString(PATH)).asGif().placeholder(R.drawable.img_pic_big_default).error(R.drawable.img_pic_big_default).diskCacheStrategy(DiskCacheStrategy.SOURCE).into(imageView);
        } else {
            progressBar.setVisibility(0);
            Glide.with((Context)container.getContext()).load(this.getArguments().getString(PATH)).asBitmap().diskCacheStrategy(DiskCacheStrategy.ALL).into((Target)new SimpleTarget<Bitmap>(Integer.MIN_VALUE, Integer.MIN_VALUE){

                public void onResourceReady(Bitmap resource, GlideAnimation<? super Bitmap> glideAnimation) {
                    progressBar.setVisibility(8);
                    imageView.setImageBitmap(resource);
                    mAttacher.update();
                }
            });
        }
        mAttacher.setOnViewTapListener(new PhotoViewAttacher.OnViewTapListener(){

            @Override
            public void onViewTap(View view, float x, float y) {
                ImagePreviewFragment.this.getActivity().finish();
            }
        });
        return contentView;
    }
}

