/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.feedbacksdk.utils;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import com.xdja.feedbacksdk.utils.FeedbackFileProvider;
import java.io.File;

public class FileProviderUtils {
    public static Uri getUriForFile(Context context, File file) {
        context = context.getApplicationContext();
        Uri fileUri = Build.VERSION.SDK_INT >= 24 ? FileProviderUtils.getUriForFile24(context, file) : Uri.fromFile((File)file);
        return fileUri;
    }

    private static Uri getUriForFile24(Context context, File file) {
        return FeedbackFileProvider.getUriForFile((Context)context, (String)(context.getPackageName() + ".com.xdja.feedback.fileprovider"), (File)file);
    }

    public static void setIntentDataAndType(Context context, Intent intent, String type, File file, boolean writeAble) {
        context = context.getApplicationContext();
        if (Build.VERSION.SDK_INT >= 24) {
            intent.setDataAndType(FileProviderUtils.getUriForFile(context, file), type);
            intent.addFlags(1);
            if (writeAble) {
                intent.addFlags(2);
            }
        } else {
            intent.setDataAndType(Uri.fromFile((File)file), type);
        }
    }
}

