/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.feedbacksdk.widget;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.AbsListView;
import android.widget.ListView;
import android.widget.TextView;
import com.xdja.feedbacksdk.R;

public class LoadListView
extends ListView
implements AbsListView.OnScrollListener {
    private View footer;
    int totalItemCount;
    int lastVisibieItem;
    boolean isLoading;
    boolean isLoadFinish;
    IloadListener iLoadListener;
    private int currentPage = 1;
    private TextView loadTv;

    public LoadListView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView(context);
    }

    public LoadListView(Context context) {
        super(context);
        this.initView(context);
    }

    public LoadListView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initView(context);
    }

    private void initView(Context context) {
        LayoutInflater inflater = LayoutInflater.from((Context)context);
        this.footer = inflater.inflate(R.layout.load_more_view, null);
        this.footer.setClickable(false);
        this.footer.setEnabled(false);
        this.footer.findViewById(R.id.footer_layout).setVisibility(8);
        this.loadTv = (TextView)this.footer.findViewById(R.id.load_text);
        this.addFooterView(this.footer);
        this.setOnScrollListener(this);
    }

    public void onScrollStateChanged(AbsListView view, int scrollState) {
        if (this.totalItemCount == this.lastVisibieItem && scrollState == 0 && !this.isLoading) {
            this.isLoading = true;
            if (!this.isLoadFinish) {
                this.footer.findViewById(R.id.footer_layout).setVisibility(0);
            }
            ++this.currentPage;
            this.iLoadListener.onLoad(this.currentPage);
        }
    }

    public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
        this.lastVisibieItem = firstVisibleItem + visibleItemCount;
        this.totalItemCount = totalItemCount;
    }

    public void setInterface(IloadListener iLoadListener) {
        this.iLoadListener = iLoadListener;
    }

    public void loadComplete() {
        this.isLoading = false;
        this.footer.findViewById(R.id.footer_layout).setVisibility(8);
    }

    public void setLoadState(boolean isFinish) {
        this.isLoadFinish = isFinish;
        if (isFinish) {
            this.currentPage = 1;
        }
    }

    public void setLoadText(String text) {
        if (this.loadTv != null) {
            this.loadTv.setText((CharSequence)text);
        }
    }

    public static interface IloadListener {
        public void onLoad(int var1);
    }
}

