/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.feedbacksdk.widget;

import android.content.Context;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.widget.CheckBox;
import android.widget.LinearLayout;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Random;

public class MultiLinearLayout
extends LinearLayout
implements View.OnClickListener {
    private int mLeft;
    private int mRight;
    private int mTop;
    private int mBottom;
    private Hashtable<View, Position> map = new Hashtable();
    private OnNameButtonListener nameButtonListener;
    private Map<View, String> btnManager = new HashMap<View, String>();
    private int dividerLine = 5;
    private int dividerCol = 8;

    public MultiLinearLayout(Context context) {
        super(context);
    }

    public MultiLinearLayout(Context context, int horizontalSpacing, int verticalSpacing) {
        super(context);
    }

    public MultiLinearLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int mWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int mCount = this.getChildCount();
        this.mLeft = 0;
        this.mRight = 0;
        this.mTop = 5;
        this.mBottom = 0;
        int j = 0;
        for (int i = 0; i < mCount; ++i) {
            View child = this.getChildAt(i);
            child.measure(0, 0);
            int childw = child.getMeasuredWidth();
            int childh = child.getMeasuredHeight();
            this.mRight += childw;
            Position position = new Position();
            this.mLeft = this.getPosition(i - j, i);
            this.mRight = this.mLeft + child.getMeasuredWidth();
            if (this.mRight >= mWidth) {
                j = i;
                this.mLeft = this.getPaddingLeft();
                this.mRight = this.mLeft + child.getMeasuredWidth();
                this.mTop += childh + this.dividerLine;
            }
            this.mBottom = this.mTop + child.getMeasuredHeight();
            position.left = this.mLeft;
            position.top = this.mTop;
            position.right = this.mRight;
            position.bottom = this.mBottom;
            this.map.put(child, position);
        }
        this.setMeasuredDimension(mWidth, this.mBottom + this.getPaddingBottom());
    }

    protected LinearLayout.LayoutParams generateDefaultLayoutParams() {
        return new LinearLayout.LayoutParams(1, 1);
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            Position pos = this.map.get(child);
            if (pos != null) {
                child.layout(pos.left, pos.top, pos.right, pos.bottom);
                continue;
            }
            Log.i((String)"MyLayout", (String)"error");
        }
    }

    public void addNameBtn(Context context, String showFrom, CheckBox btnView, String tag) {
        if (TextUtils.isEmpty((CharSequence)showFrom)) {
            return;
        }
        if (this.btnManager.containsValue(showFrom)) {
            return;
        }
        if (btnView == null) {
            return;
        }
        CheckBox btn = btnView;
        Random random = new Random();
        int id2 = random.nextInt(100000);
        btn.setId(id2);
        btn.setGravity(17);
        btn.setText((CharSequence)showFrom);
        btn.setOnClickListener((View.OnClickListener)this);
        this.addView((View)btn);
        this.btnManager.put((View)btn, tag);
    }

    public void onClick(View v) {
        if (this.nameButtonListener != null) {
            this.nameButtonListener.onNameBtnClick(v, this.btnManager.get(v));
        }
    }

    public int getPosition(int IndexInRow, int childIndex) {
        if (IndexInRow > 0) {
            return this.getPosition(IndexInRow - 1, childIndex - 1) + this.getChildAt(childIndex - 1).getMeasuredWidth() + this.dividerCol;
        }
        return this.getPaddingLeft();
    }

    public Map<View, String> getBtnManager() {
        return this.btnManager;
    }

    public void setmLeft(int mLeft) {
        this.mLeft = mLeft;
    }

    public void setmRight(int mRight) {
        this.mRight = mRight;
    }

    public void setmTop(int mTop) {
        this.mTop = mTop;
    }

    public void setmBottom(int mBottom) {
        this.mBottom = mBottom;
    }

    public void setMap(Hashtable<View, Position> map) {
        this.map = map;
    }

    public void setNameButtonListener(OnNameButtonListener nameButtonListener) {
        this.nameButtonListener = nameButtonListener;
    }

    public void setMailBtnManager(Map<View, String> mailBtnManager) {
        this.btnManager = mailBtnManager;
    }

    public void setMaginLeftAndRight(int magin) {
        this.dividerCol = magin;
    }

    public void setMaginTopAndBottom(int magin) {
        this.dividerLine = magin;
    }

    public static interface OnNameButtonListener {
        public void onNameBtnClick(View var1, String var2);
    }

    private class Position {
        int left;
        int top;
        int right;
        int bottom;

        private Position() {
        }
    }
}

