/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.feedbacksdk.widget;

import android.content.Context;
import android.support.v4.widget.SwipeRefreshLayout;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.widget.AbsListView;
import android.widget.ListAdapter;
import android.widget.ListView;
import com.xdja.feedbacksdk.R;

public class MySwipeRefreshLayout
extends SwipeRefreshLayout
implements AbsListView.OnScrollListener {
    private int mTouchSlop;
    private ListView mListView;
    private OnLoadListener mOnLoadListener;
    private View mFooterView;
    private int mYDown;
    private boolean isLoading = false;
    private float mLastY = -1.0f;
    boolean isLastRow = false;
    private boolean moreData = true;

    public MySwipeRefreshLayout(Context context) {
        super(context);
    }

    public MySwipeRefreshLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mTouchSlop = ViewConfiguration.get((Context)context).getScaledTouchSlop();
        this.mFooterView = LayoutInflater.from((Context)context).inflate(R.layout.xdja_feed_back_swipere_fresh_layout_footer, null, false);
    }

    public void setView(Context context, View childView) {
        if (childView instanceof ListView) {
            this.mListView = (ListView)childView;
            this.mListView.setOnScrollListener((AbsListView.OnScrollListener)this);
            this.mListView.setFooterDividersEnabled(false);
        }
        this.initWithContext(context);
    }

    private void initWithContext(Context context) {
        if (this.mListView != null) {
            this.mListView.addFooterView(this.mFooterView, null, false);
        }
        this.mFooterView.setVisibility(8);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
    }

    private boolean canLoad(boolean canload) {
        return canload && !this.isLoading && this.isPullUp();
    }

    private boolean isBottom() {
        if (this.mListView != null && this.mListView.getAdapter() != null) {
            return this.mListView.getLastVisiblePosition() == this.mListView.getAdapter().getCount() - 1;
        }
        return false;
    }

    private boolean isPullUp() {
        return (float)this.mYDown - this.mLastY >= (float)this.mTouchSlop;
    }

    private void loadData() {
        if (this.mOnLoadListener != null) {
            this.setLoading(true);
            this.mOnLoadListener.onLoadMore();
        }
    }

    public void setLoading(boolean loading) {
        this.isLoading = loading;
        if (this.isLoading) {
            this.mFooterView.setVisibility(0);
        } else {
            this.mFooterView.setVisibility(8);
            this.mYDown = 0;
            this.mLastY = 0.0f;
        }
    }

    public boolean dispatchTouchEvent(MotionEvent event) {
        int action = event.getAction();
        if (this.mLastY == -1.0f) {
            this.mLastY = (int)event.getRawY();
        }
        switch (action) {
            case 0: {
                this.mYDown = (int)event.getRawY();
                break;
            }
            case 2: {
                this.mLastY = (int)event.getRawY();
                float deltaY = event.getRawY() - this.mLastY;
                break;
            }
        }
        return super.dispatchTouchEvent(event);
    }

    public void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    public void setOnLoadListener(OnLoadListener loadListener) {
        this.mOnLoadListener = loadListener;
    }

    public void onScrollStateChanged(AbsListView absListView, int i) {
    }

    public void onScroll(AbsListView absListView, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
        if (firstVisibleItem + visibleItemCount == totalItemCount && totalItemCount > 0) {
            if (absListView.getLastVisiblePosition() == ((ListAdapter)absListView.getAdapter()).getCount() - 1) {
                this.isLastRow = true;
                if (this.canLoad(this.moreData)) {
                    this.loadData();
                }
            }
        } else {
            this.isLastRow = false;
        }
    }

    public boolean isMoreData() {
        return this.moreData;
    }

    public void setMoreData(boolean moreData) {
        this.moreData = moreData;
        if (!moreData && this.mListView.getFooterViewsCount() == 1) {
            this.mListView.removeFooterView(this.mFooterView);
            return;
        }
        if (moreData && this.mListView.getFooterViewsCount() == 0) {
            this.mListView.addFooterView(this.mFooterView);
            return;
        }
    }

    public void setFirstEnterLoading(boolean loading) {
        if (loading) {
            this.post(new Runnable(){

                @Override
                public void run() {
                    MySwipeRefreshLayout.this.setRefreshing(true);
                }
            });
        }
    }

    public static interface OnLoadListener {
        public void onLoadMore();
    }
}

