package com.xdja.framework.commons.utils.http;

import org.apache.http.Consts;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.ParseException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.util.EntityUtils;

import java.io.IOException;

/**
 * Http请求响应包装类
 *
 * @author hsun
 * @version 1.0
 * @since 2018/9/5 上午10:47
 */
public class ResponseWrap {
    /**
     * 响应
     */
    private CloseableHttpResponse response;
    private HttpEntity entity;

    public ResponseWrap(CloseableHttpResponse response) {
        this.response = response;

        try {
            HttpEntity entity = response.getEntity();
            if (null != entity) {
                this.entity = new BufferedHttpEntity(entity);
            } else {
                this.entity = new BasicHttpEntity();
            }

            EntityUtils.consume(entity);
            this.response.close();
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    /**
     * 获取响应字符串
     * @return
     */
    public String getString() {
        try {
            return EntityUtils.toString(entity, Consts.UTF_8);
        } catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    /**
     * 获取响应字节流
     * @return
     */
    public byte[] getBytes() {
        try {
            return EntityUtils.toByteArray(entity);
        } catch (ParseException | IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    /**
     * 获取响应状态码
     * @return
     */
    public int getStatusCode(){
        return response.getStatusLine().getStatusCode();
    }

    /**
     * 获取所有响应头
     * @return
     */
    public Header[] getAllHeaders() {
        return response.getAllHeaders();
    }

    /**
     * 获取指定响应头
     * @param name
     * @return
     */
    public Header[] getHeaders(String name) {
        return response.getHeaders(name);
    }

    /**
     * 获取Response
     * @return
     */
    public CloseableHttpResponse getHttpResponse() {
        return response;
    }
}
