//================================================
// 前端自增唯一ID的一种实现   基于Twitter雪花算法
// 生成一个10位的自增ID
// @author hsun
// @version 1.0
// @date 2018-09-07 17:09:17
//================================================


/**
 * 机器ID
 */
var workerId;

/**
 * 数据标识ID
 */
var dataCenterId;

/**
 * 序列
 */
var sequence = 0;

/**
 * 开始时间戳 2015-09-07 12:00:00
 */
var twepoch = 1441598400000;

/**
 * 机器ID所占的位数
 */
var workerIdBits = 2;

/**
 * 数据标识ID所占的位数
 */
var datacenterIdBits = 2;

/**
 * 序列在ID中的位数
 */
var sequenceBits = 4;

/**
 * 最大机器ID
 */
var maxWorkerId = -1 ^ (-1 << workerIdBits);

/**
 * 最大数据标识ID
 */
var maxDataCenterId  = -1 ^ (-1 << datacenterIdBits);

var workerIdShift = sequenceBits;
var datacenterIdShift  = sequenceBits + workerIdBits;
var timestampLeftShift = sequenceBits + workerIdBits + datacenterIdBits;
var sequenceMask = -1 ^ (-1 << sequenceBits);

/**
 * 上次生成ID的时间戳
 */
var lastTimestamp = -1;

workerId = parseInt(Math.random() * maxWorkerId, 10) + 1;
dataCenterId = parseInt(Math.random() * maxDataCenterId, 10) + 1;

function nextId() {
   var timestamp = timeGen();
    if (timestamp < lastTimestamp) {
        alert("Clock moved backwards.  Refusing to generate id for " + (lastTimestamp - timestamp) + " milliseconds");
    }

    if (timestamp == lastTimestamp ) {
        sequence = (sequence + 1) & sequenceMask;
        if (sequence == 0) {
            timestamp = waitNextMillis(timestamp);
        }
    } else {
        sequence = 0;
    }

    lastTimestamp = timestamp;

    return ((timestamp - twepoch) << timestampLeftShift) |
        (dataCenterId << datacenterIdShift) |
        (workerId << workerIdShift) |
        sequence;
}


function waitNextMillis(lastTimestamp) {
    var timestamp = timeGen();
    while (timestamp <= lastTimestamp) {
        timestamp = timeGen();
    }
    return timestamp;
}

function timeGen() {
    return new Date().getTime();
}