/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.framework.commons.utils;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class DigestUtil {
    public static String md5Digest(String proto) {
        return DigestUtil.md5Digest(proto, null);
    }

    public static String md5Digest(String proto, String salt) {
        if (salt != null) {
            proto = proto + salt;
        }
        return DigestUtil.digest(proto, "MD5");
    }

    public static String sha1Digest(String proto) {
        return DigestUtil.sha1Digest(proto, null);
    }

    public static String sha1Digest(String proto, String salt) {
        if (salt != null) {
            proto = proto + salt;
        }
        return DigestUtil.digest(proto, "SHA1");
    }

    private static String digest(String proto, String type) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(type);
            byte[] inputByteArray = proto.getBytes();
            messageDigest.update(inputByteArray);
            byte[] resultByteArray = messageDigest.digest();
            return DigestUtil.byteArrayToHex(resultByteArray);
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
    }

    private static String byteArrayToHex(byte[] byteArray) {
        char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        char[] resultCharArray = new char[byteArray.length * 2];
        int index = 0;
        for (byte b : byteArray) {
            resultCharArray[index++] = hexDigits[b >>> 4 & 0xF];
            resultCharArray[index++] = hexDigits[b & 0xF];
        }
        return new String(resultCharArray);
    }
}

