/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.framework.commons.utils.http;

import com.alibaba.fastjson.JSON;
import com.xdja.framework.commons.utils.http.ResponseWrap;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.NameValuePair;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.EntityBuilder;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContextBuilder;
import org.apache.http.conn.ssl.SSLContexts;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.DefaultProxyRoutePlanner;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpContext;

public class HttpUtils {
    private boolean isHttps;
    private int type;
    private HttpRequestBase request;
    private CloseableHttpClient httpClient;
    private EntityBuilder builder;
    private URIBuilder uriBuilder;
    private LayeredConnectionSocketFactory socketFactory;
    private HttpClientBuilder clientBuilder;
    private RequestConfig.Builder config;

    private HttpUtils(HttpRequestBase request) {
        this.isHttps = request.getURI().getScheme().equalsIgnoreCase("https");
        this.request = request;
        this.clientBuilder = HttpClientBuilder.create();
        this.config = RequestConfig.custom().setCookieSpec("compatibility");
        if (request instanceof HttpPost) {
            this.type = 1;
            this.builder = EntityBuilder.create().setParameters(new ArrayList());
        }
        if (request instanceof HttpGet) {
            this.type = 2;
            this.uriBuilder = new URIBuilder();
        }
        if (request instanceof HttpPut) {
            this.type = 3;
            this.builder = EntityBuilder.create().setParameters(new ArrayList());
        }
        if (request instanceof HttpDelete) {
            this.type = 4;
            this.uriBuilder = new URIBuilder();
        }
    }

    private static HttpUtils create(HttpRequestBase request) {
        return new HttpUtils(request);
    }

    public static HttpUtils post(String url) {
        return HttpUtils.create((HttpRequestBase)new HttpPost(url));
    }

    public static HttpUtils post(URI uri) {
        return HttpUtils.create((HttpRequestBase)new HttpPost(uri));
    }

    public static HttpUtils get(String url) {
        return HttpUtils.create((HttpRequestBase)new HttpGet(url));
    }

    public static HttpUtils get(URI uri) {
        return HttpUtils.create((HttpRequestBase)new HttpGet(uri));
    }

    public static HttpUtils put(String url) {
        return HttpUtils.create((HttpRequestBase)new HttpPut(url));
    }

    public static HttpUtils put(URI uri) {
        return HttpUtils.create((HttpRequestBase)new HttpPut(uri));
    }

    public static HttpUtils delete(String url) {
        return HttpUtils.create((HttpRequestBase)new HttpDelete(url));
    }

    public static HttpUtils delete(URI uri) {
        return HttpUtils.create((HttpRequestBase)new HttpDelete(uri));
    }

    public HttpUtils addParameter(String name, String value) {
        if (this.builder != null) {
            this.builder.getParameters().add(new BasicNameValuePair(name, value));
        } else {
            this.uriBuilder.addParameter(name, value);
        }
        return this;
    }

    public HttpUtils addParameters(Map<String, String> parameters) {
        ArrayList<BasicNameValuePair> values = new ArrayList<BasicNameValuePair>(parameters.size());
        for (Map.Entry<String, String> parameter : parameters.entrySet()) {
            values.add(new BasicNameValuePair(parameter.getKey(), parameter.getValue()));
        }
        if (this.builder != null) {
            this.builder.getParameters().addAll(values);
        } else {
            this.uriBuilder.addParameters(values);
        }
        return this;
    }

    public HttpUtils addParameters(NameValuePair ... parameters) {
        if (this.builder != null) {
            this.builder.getParameters().addAll(Arrays.asList(parameters));
        } else {
            this.uriBuilder.addParameters(Arrays.asList(parameters));
        }
        return this;
    }

    public HttpUtils addBytes(byte[] bytes) {
        this.builder.setContentType(ContentType.APPLICATION_OCTET_STREAM);
        this.builder.setBinary(bytes);
        return this;
    }

    public HttpUtils setParameters(Map<String, String> parameters) {
        NameValuePair[] values = new NameValuePair[parameters.size()];
        int i = 0;
        for (Map.Entry<String, String> parameter : parameters.entrySet()) {
            values[i++] = new BasicNameValuePair(parameter.getKey(), parameter.getValue());
        }
        this.setParameters(values);
        return this;
    }

    public HttpUtils setParameters(NameValuePair ... parameters) {
        if (this.builder != null) {
            this.builder.setParameters(parameters);
        } else {
            this.uriBuilder.setParameters(parameters);
        }
        return this;
    }

    public HttpUtils setBytes(byte[] binary) {
        if (this.builder == null) {
            throw new UnsupportedOperationException();
        }
        this.builder.setBinary(binary);
        return this;
    }

    public HttpUtils setFile(File file) {
        if (this.builder == null) {
            throw new UnsupportedOperationException();
        }
        this.builder.setFile(file);
        return this;
    }

    public HttpUtils setStream(InputStream is) {
        if (this.builder == null) {
            throw new UnsupportedOperationException();
        }
        this.builder.setStream(is);
        return this;
    }

    public HttpUtils addJson(Object object) {
        if (this.builder == null) {
            throw new UnsupportedOperationException();
        }
        this.builder.setContentType(ContentType.APPLICATION_JSON);
        this.builder.setBinary(JSON.toJSONString((Object)object).getBytes());
        return this;
    }

    public HttpUtils addHeader(String name, String value) {
        this.request.addHeader(name, value);
        return this;
    }

    public HttpUtils addHeader(Map<String, String> headers) {
        for (Map.Entry<String, String> header : headers.entrySet()) {
            this.request.addHeader(header.getKey(), header.getValue());
        }
        return this;
    }

    public HttpUtils setProxy(String hostname, int port) {
        HttpHost httpHost = new HttpHost(hostname, port);
        return this.setProxy(httpHost);
    }

    private HttpUtils setProxy(HttpHost host) {
        DefaultProxyRoutePlanner routePlanner = new DefaultProxyRoutePlanner(host);
        this.clientBuilder.setRoutePlanner((HttpRoutePlanner)routePlanner);
        return this;
    }

    public HttpUtils setJKS(String jksFilePath, String password) {
        return this.setJKS(new File(jksFilePath), password);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HttpUtils setJKS(File jksFile, String password) {
        try (FileInputStream instream = new FileInputStream(jksFile);){
            HttpUtils httpUtils = this.setJKS(instream, password);
            return httpUtils;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public HttpUtils setJKS(InputStream is, String password) {
        try {
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(is, password.toCharArray());
            return this.setJKS(keyStore, password);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public HttpUtils setJKS(KeyStore keyStore, String password) {
        try {
            SSLContext sslContext = SSLContexts.custom().useTLS().loadKeyMaterial(keyStore, password.toCharArray()).loadTrustMaterial(keyStore).build();
            this.socketFactory = new SSLConnectionSocketFactory(sslContext, SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return this;
    }

    public HttpUtils setContentEncoding(String encoding) {
        if (this.builder != null) {
            this.builder.setContentEncoding(encoding);
        }
        return this;
    }

    public HttpUtils setContentType(ContentType contentType) {
        if (this.builder != null) {
            this.builder.setContentType(contentType);
        }
        return this;
    }

    public HttpUtils setContentType(String mimeType, Charset charset) {
        if (this.builder != null) {
            this.builder.setContentType(ContentType.create((String)mimeType, (Charset)charset));
        }
        return this;
    }

    public HttpUtils setSocketTimeout(int socketTimeout) {
        this.config.setSocketTimeout(socketTimeout);
        return this;
    }

    public HttpUtils setConnectTimeout(int connectTimeout) {
        this.config.setConnectTimeout(connectTimeout);
        return this;
    }

    public HttpUtils setConnectionRequestTimeout(int connectionRequestTimeout) {
        this.config.setConnectionRequestTimeout(connectionRequestTimeout);
        return this;
    }

    public ResponseWrap execute() {
        return this.execute(null);
    }

    public ResponseWrap execute(MultipartEntityBuilder multiBuilder) {
        this.settingRequest(multiBuilder);
        if (null == this.httpClient) {
            this.httpClient = this.clientBuilder.build();
        }
        try {
            HttpClientContext context = HttpClientContext.create();
            CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)this.request, (HttpContext)context);
            return new ResponseWrap(response);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private void settingRequest(MultipartEntityBuilder multiBuilder) {
        URI uri = null;
        if (this.uriBuilder != null && this.uriBuilder.getQueryParams().size() != 0) {
            try {
                uri = this.uriBuilder.setPath(this.request.getURI().toString()).build();
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        HttpEntity httpEntity = null;
        switch (this.type) {
            case 1: {
                httpEntity = this.getEntityBuilder(multiBuilder);
                if (httpEntity.getContentLength() <= 0L) break;
                ((HttpPost)this.request).setEntity(httpEntity);
                break;
            }
            case 2: {
                HttpGet get = (HttpGet)this.request;
                if (uri == null) break;
                get.setURI(uri);
                break;
            }
            case 3: {
                httpEntity = this.getEntityBuilder(multiBuilder);
                if (httpEntity.getContentLength() <= 0L) break;
                ((HttpPut)this.request).setEntity(httpEntity);
                break;
            }
            case 4: {
                HttpDelete delete = (HttpDelete)this.request;
                if (uri == null) break;
                delete.setURI(uri);
            }
        }
        if (this.isHttps && null != this.socketFactory) {
            this.clientBuilder.setSSLSocketFactory(this.socketFactory);
        } else if (this.isHttps) {
            this.clientBuilder.setSSLSocketFactory(this.getSSLSocketFactory());
        }
        this.request.setConfig(this.config.build());
    }

    private HttpEntity getEntityBuilder(MultipartEntityBuilder multiBuilder) {
        HttpEntity httpEntity = multiBuilder != null ? multiBuilder.build() : this.builder.build();
        return httpEntity;
    }

    private LayeredConnectionSocketFactory getSSLSocketFactory() {
        try {
            SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, new TrustStrategy(){

                public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    return true;
                }
            }).build();
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContext, SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
            return sslsf;
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public FormEntity newForm() {
        return new FormEntity(this);
    }

    public class FormEntity {
        private MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        private HttpUtils httpUtils;

        public FormEntity(HttpUtils httpUtils2) {
            this.httpUtils = httpUtils2;
            this.builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
            this.builder.setCharset(Charset.forName("UTF-8"));
        }

        public FormEntity addParamter(String name, String value) {
            this.builder.addTextBody(name, value, ContentType.TEXT_PLAIN.withCharset(Charset.forName("UTF-8")));
            return this;
        }

        public FormEntity addParamters(Map<String, String> params) {
            if (!params.isEmpty()) {
                for (Map.Entry<String, String> parameter : params.entrySet()) {
                    this.addParamter(parameter.getKey(), parameter.getValue());
                }
            }
            return this;
        }

        public FormEntity addParamter(String name, byte[] bytes) {
            this.builder.addBinaryBody(name, bytes);
            return this;
        }

        public FormEntity addParamter(String name, byte[] bytes, ContentType contentType, String filename) {
            this.builder.addBinaryBody(name, bytes, contentType, filename);
            return this;
        }

        public FormEntity setBoundary(String boundary) {
            this.builder.setBoundary(boundary);
            return this;
        }

        public ResponseWrap execute() {
            return this.httpUtils.execute(this.builder);
        }
    }
}

