/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.framework.commons.utils.http;

import java.io.IOException;
import java.nio.charset.Charset;
import org.apache.http.Consts;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.ParseException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.util.EntityUtils;

public class ResponseWrap {
    private CloseableHttpResponse response;
    private HttpEntity entity;

    public ResponseWrap(CloseableHttpResponse response) {
        this.response = response;
        try {
            HttpEntity entity = response.getEntity();
            this.entity = null != entity ? new BufferedHttpEntity(entity) : new BasicHttpEntity();
            EntityUtils.consume((HttpEntity)entity);
            this.response.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getString() {
        try {
            return EntityUtils.toString((HttpEntity)this.entity, (Charset)Consts.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public byte[] getBytes() {
        try {
            return EntityUtils.toByteArray((HttpEntity)this.entity);
        }
        catch (IOException | ParseException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public int getStatusCode() {
        return this.response.getStatusLine().getStatusCode();
    }

    public Header[] getAllHeaders() {
        return this.response.getAllHeaders();
    }

    public Header[] getHeaders(String name) {
        return this.response.getHeaders(name);
    }

    public CloseableHttpResponse getHttpResponse() {
        return this.response;
    }
}

