/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.framework.commons.utils.id;

import com.xdja.framework.commons.utils.DigestUtil;
import com.xdja.framework.commons.utils.RandomUtil;
import com.xdja.framework.commons.utils.UUIDUtil;
import com.xdja.framework.commons.utils.id.SnowflakeIdGenerator;

public interface IDGenerator<T> {
    public static final IDGenerator<String> UUID = new IDGenerator<String>(){

        @Override
        public String generate() {
            return UUIDUtil.random();
        }
    };
    public static final IDGenerator<String> RANDOM = new IDGenerator<String>(){

        @Override
        public String generate() {
            return RandomUtil.randomChar();
        }
    };
    public static final IDGenerator<String> MD5 = new IDGenerator<String>(){

        @Override
        public String generate() {
            return DigestUtil.md5Digest(UUIDUtil.random().concat(RandomUtil.randomChar()));
        }
    };
    public static final IDGenerator<Long> SNOW_FLAKE = new IDGenerator<Long>(){

        @Override
        public Long generate() {
            return SnowflakeIdGenerator.getInstance().nextId();
        }
    };
    public static final IDGenerator<String> SNOW_FLAKE_STR = new IDGenerator<String>(){

        @Override
        public String generate() {
            return String.valueOf(SnowflakeIdGenerator.getInstance().nextId());
        }
    };

    public T generate();
}

