/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.framework.logging;

import com.xdja.framework.commons.utils.id.IDGenerator;
import com.xdja.framework.logging.AccessLogger;
import com.xdja.framework.logging.AccessLoggerInfo;
import com.xdja.framework.logging.IAccessLoggerListener;
import com.xdja.framework.logging.MethodInterceptorHolder;
import com.xdja.framework.logging.WebUtil;
import java.lang.reflect.Method;
import javax.servlet.http.HttpServletRequest;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.support.StaticMethodMatcherPointcutAdvisor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestMapping;

@Component
public class AopAccessLoggerSupport
extends StaticMethodMatcherPointcutAdvisor {
    @Autowired
    private IAccessLoggerListener loggerListener;

    public AopAccessLoggerSupport() {
        this.setAdvice((Advice)new MethodInterceptor(){

            public Object invoke(MethodInvocation invocation) throws Throwable {
                Object response;
                MethodInterceptorHolder interceptorHolder = MethodInterceptorHolder.create(invocation);
                AccessLoggerInfo info = AopAccessLoggerSupport.this.createLogger(interceptorHolder);
                AopAccessLoggerSupport.this.loggerListener.onLoggerBefore(info);
                try {
                    response = invocation.proceed();
                    info.setResponse(response);
                    info.setResponseTime(System.currentTimeMillis());
                }
                catch (Throwable e) {
                    info.setException(e);
                    throw e;
                }
                finally {
                    AopAccessLoggerSupport.this.loggerListener.onLogger(info);
                }
                return response;
            }
        });
    }

    private AccessLoggerInfo createLogger(MethodInterceptorHolder holder) {
        AccessLoggerInfo info = new AccessLoggerInfo();
        info.setId((String)IDGenerator.SNOW_FLAKE_STR.generate());
        info.setRequestTime(System.currentTimeMillis());
        AccessLogger methodAnn = holder.findMethodAnnotation(AccessLogger.class);
        info.setAction(methodAnn.value());
        info.setDescribe(methodAnn.describe());
        info.setMethod(holder.getMethod());
        info.setParameters(holder.getArgs());
        info.setTarget(holder.getTarget());
        HttpServletRequest request = WebUtil.getHttpServletRequest();
        if (null != request) {
            info.setHttpHeaders(WebUtil.getHeaders(request));
            info.setIp(WebUtil.getIpAddr(request));
            info.setHttpMethod(request.getMethod());
            info.setUrl(request.getRequestURL().toString());
        }
        return info;
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    public boolean matches(Method method, Class<?> aClass) {
        AccessLogger ann = (AccessLogger)AnnotationUtils.findAnnotation((Method)method, AccessLogger.class);
        RequestMapping req = (RequestMapping)AnnotationUtils.findAnnotation((Method)method, RequestMapping.class);
        if (null != ann && null != req) {
            return !ann.ignore();
        }
        return false;
    }
}

