/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.framework.logging;

import com.xdja.framework.logging.AopUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.util.DigestUtils;

public class MethodInterceptorHolder {
    public static final ParameterNameDiscoverer nameDiscoverer = new LocalVariableTableParameterNameDiscoverer();
    private String id;
    private Method method;
    private Object target;
    private Map<String, Object> args;

    public MethodInterceptorHolder(String id, Method method, Object target, Map<String, Object> args) {
        this.id = id;
        this.method = method;
        this.target = target;
        this.args = args;
    }

    public static MethodInterceptorHolder create(MethodInvocation methodInvocation) {
        String id = DigestUtils.md5DigestAsHex((byte[])String.valueOf(methodInvocation.getMethod().hashCode()).getBytes());
        String[] argNames = nameDiscoverer.getParameterNames(methodInvocation.getMethod());
        Object[] args = methodInvocation.getArguments();
        LinkedHashMap<String, Object> argMap = new LinkedHashMap<String, Object>();
        int len = args.length;
        for (int i = 0; i < len; ++i) {
            argMap.put(argNames == null || argNames[i] == null ? "arg" + i : argNames[i], args[i]);
        }
        return new MethodInterceptorHolder(id, methodInvocation.getMethod(), methodInvocation.getThis(), argMap);
    }

    public <T extends Annotation> T findMethodAnnotation(Class<T> annClass) {
        return AopUtils.findMethodAnnotation(annClass, this.method, annClass);
    }

    public <T extends Annotation> T findClassAnnotation(Class<T> annClass) {
        return AopUtils.findAnnotation(this.target.getClass(), annClass);
    }

    public <T extends Annotation> T findAnnotation(Class<T> annClass) {
        return AopUtils.findAnnotation(this.target.getClass(), this.method, annClass);
    }

    public String getId() {
        return this.id;
    }

    public Method getMethod() {
        return this.method;
    }

    public Object getTarget() {
        return this.target;
    }

    public Map<String, Object> getArgs() {
        return this.args;
    }
}

