package com.xdja.framework.validation.annotation;

import static java.lang.annotation.ElementType.FIELD;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

import com.xdja.framework.validation.validator.Validator;

@Documented
@Retention(RUNTIME)
@Target(FIELD)
public @interface Binding {
	
	//FIXME 不支持循环注入
	// Binding和InjectBinding两个字段的关系，必须是同属一个类中的字段（可以是继承关系中的字段）

	/**
	 * 指定绑定名
	 * @return
	 */
	String name();

	/**
	 * 指定校验器
	 * @return
	 */
	@SuppressWarnings("rawtypes")
	Class<? extends Validator> value();

	/**
	 * 字段多个校验器的校验顺序
	 * @return
	 */
	int order() default 1;

}
