package com.xdja.framework.validation.annotation;

import static java.lang.annotation.ElementType.FIELD;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

import com.xdja.framework.validation.validator.internal.EmptyCheckValidator;

@Target({ FIELD })
@Retention(RUNTIME)
@ValidatorConstraint(EmptyCheckValidator.class)
@Documented
public @interface EmptyCheck {

	CheckType checkType();

	String message() default "{fieldName}不可为空";

	int order() default 1;
	
	public enum CheckType{
		NULL,
		NOT_NULL,
		NOT_EMPTY,
		NOT_BLANK
	}

}
