package com.xdja.framework.validation.annotation;

import static java.lang.annotation.ElementType.ANNOTATION_TYPE;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

import java.lang.annotation.Annotation;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

import com.xdja.framework.validation.validator.Validator;

/**
 * 用于定义分组内的Field
 * 
 * @author lvhao
 *
 */
@Documented
@Retention(RUNTIME)
@Target({ANNOTATION_TYPE })
public @interface Field {

	/**
	 * 字段名
	 * @return
	 */
	String name();
	/**
	 * 指定部分校验器，字段本身有多个注解校验器，只选取部分的校验器，特别地，在分组校验中使用
	 * @return
	 */
	Class<? extends Annotation>[] annotations() default {};
	
	/**
	 * 指定新的验证器，一旦指定验证器，则不再使用field注解校验
	 * annotations和validators是互斥的
	 * @return
	 */
	@SuppressWarnings("rawtypes")
	Class<? extends Validator>[] validators() default {};
	
	/**
	 * 字段对象中的分组。
	 * 要想验证对象中的某些字段，在引用对象中必须指定字段分组，在此注解中指定这些分组就行
	 * @return
	 */
	String[] groups() default {};
	
	
}
