package com.xdja.framework.validation.annotation;

import static java.lang.annotation.ElementType.ANNOTATION_TYPE;
import static java.lang.annotation.ElementType.FIELD;
import static java.lang.annotation.ElementType.TYPE;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

import com.xdja.framework.validation.validator.Validator;


@Documented
@Retention(RUNTIME)
@Target({TYPE, FIELD, ANNOTATION_TYPE})
public @interface Group {

	/**
	 * 分组名称
	 * @return
	 */
	String name();
	
	/**
	 * 指定该分组需要验证的属性
	 * @return
	 */
	Field[] fields() default {};
	
	/**
	 * 类级别的校验器，一旦指定，则验证整个对象，不再是验证某个字段。与fields互斥。只能指定一个类级别的校验器。
	 * @return
	 */
	@SuppressWarnings("rawtypes")
	Class<? extends Validator>[] validators() default {};
	
	
	@Target({TYPE, FIELD, ANNOTATION_TYPE})
	@Retention(RUNTIME)
	@Documented
	public @interface List {
		Group[] value() default {};
	}
}
