package com.xdja.framework.validation.annotation;

import static java.lang.annotation.ElementType.FIELD;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

import com.xdja.framework.validation.validator.internal.LengthValidator;

/**
 * 用于验证指定值的长度，如字符串length、数组length、Collection的size、Map.Key的size
 * 
 * @author  lvhao
 * @date    2019年6月21日 下午4:52:24
 * @version 1.0
 */
@Documented
@Retention(RUNTIME)
@Target(FIELD)
@ValidatorConstraint(LengthValidator.class)
public @interface Length {
	
	int min() default 0;

	int max() default Integer.MAX_VALUE;

	String message() default "";

	int order() default 1;
}
