package com.xdja.framework.validation.annotation;

import static java.lang.annotation.ElementType.FIELD;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

import com.xdja.framework.validation.validator.internal.NumberValidator;

/**
 * 验证数字类型，如byte,short,int,long,float,double。
 * @author  lvhao
 * @date    2019年6月21日 下午4:59:31
 * @version 1.0
 */
@Documented
@Retention(RUNTIME)
@Target(FIELD)
@ValidatorConstraint(NumberValidator.class)
public @interface Number {

	/**
	 * 数字类型
	 * @return
	 */
	NumberType type() default NumberType.INT;
	/**
	 * 最小值
	 * @return
	 */
	long min() default 0;
	/**
	 * 最大值
	 * @return
	 */
	long max() default 0;
	/**
	 * 精度
	 * @return
	 */
	int precision() default 0;
	/**
	 * 错误
	 * @return
	 */
	String message() default "";
	/**
	 * 多个校验器的先后次序
	 * @return
	 */
	int order() default 1;
	
	public enum NumberType{
		BYTE, SHORT, INT, LONG, FLOAT, DOUBLE
	}
}
