package com.xdja.framework.validation.annotation;

import static java.lang.annotation.ElementType.FIELD;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

import com.xdja.framework.validation.validator.internal.SizeValidator;

/**
 * 验证数字范围，可指定最大值和最小值。
 * @author  lvhao
 * @date    2019年6月21日 下午4:55:44
 * @version 1.0
 */
@Documented
@Retention(RUNTIME)
@Target(FIELD)
@ValidatorConstraint(SizeValidator.class)
public @interface Size {
	
	int min() default 0;
	int max() default Integer.MAX_VALUE;
	int precision() default 0;//精度
	String message() default "";
	int order() default 1;
	
}
