package com.xdja.framework.validation.annotation;

import static java.lang.annotation.ElementType.FIELD;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

import com.xdja.framework.validation.validator.Validator;

@Documented
@Retention(RUNTIME)
@Target(FIELD)
public @interface ValidatorBy {

	String name() default "";//校验器名称，只是为了区分不同Validator的名字而已
	
	@SuppressWarnings("rawtypes")
	Class<? extends Validator> value();
	
	int order() default 1;
	
}
