package com.xdja.framework.validation.handler;

import java.util.List;

import com.xdja.framework.validation.validator.ValidationError;
import com.xdja.framework.validation.validator.ValidationResult;

/**
 * 将所有验证错误使用'\n'拼接成字符串。
 * 
 * @author lvhao
 *
 */
public class SimpleValidationFormat implements ValidationFormat {

	@Override
	public String format(ValidationResult result) {
		List<ValidationError> errors = result.getErrors();

		StringBuilder out = new StringBuilder();
		for (ValidationError error : errors) {
			out.append(error.getErrorMsg()).append("\n");
		}
		return out.toString();
	}

}
