package com.xdja.framework.validation.interceptor;

import com.xdja.framework.validation.validator.ValidationResult;

/**
 * Spring验证异常
 * @author lvhao
 *
 * 修改异常类型为RuntimeException
 * 增加构造函数
 * @author hsun
 * @date 2018-09-06 18:32:03
 *
 */
public class SpringValidationException extends RuntimeException {

	private static final long serialVersionUID = 1L;

	private ValidationResult result;
	
	public SpringValidationException(ValidationResult result) {
		this.result = result;
	}

	public SpringValidationException(String message, ValidationResult result) {
		super(message);
		this.result = result;
	}

	public ValidationResult getResult() {
		return result;
	}

}
